use std::path::PathBuf;

use serde::{Deserialize, Serialize};

use crate::{
    action::{ActionError, Context},
    action_impl::ActionImpl,
};

#[derive(Debug, Clone, PartialEq, Eq, Serialize, Deserialize)]
pub struct Mkdir {
    pathname: PathBuf,
}

impl Mkdir {
    pub fn new(pathname: PathBuf) -> Self {
        Self { pathname }
    }
}

impl ActionImpl for Mkdir {
    fn execute(&self, _context: &Context) -> Result<(), ActionError> {
        if !self.pathname.exists() {
            std::fs::create_dir(&self.pathname)
                .map_err(|e| ActionError::Mkdir(self.pathname.clone(), e))?;
        }
        Ok(())
    }
}
