use serde::{Deserialize, Serialize};

use crate::{
    action::{ActionError, Context},
    action_impl::ActionImpl,
    util::rsync_server,
};

#[derive(Debug, Clone, PartialEq, Eq, Serialize, Deserialize)]
pub struct Rsync {
    rsync_target: Option<String>,
}

impl Rsync {
    pub fn new(rsync_target: Option<String>) -> Self {
        Self { rsync_target }
    }
}

impl ActionImpl for Rsync {
    fn execute(&self, context: &Context) -> Result<(), ActionError> {
        if let Some(target) = &self.rsync_target {
            rsync_server(context.artifacts_dir(), target)?;
        }
        Ok(())
    }
}
