use serde::{Deserialize, Serialize};

use crate::{
    action::{ActionError, Context},
    action_impl::ActionImpl,
    util::{changes_file, dput},
};

#[derive(Debug, Clone, PartialEq, Eq, Serialize, Deserialize)]
pub struct Dput {
    dput_target: Option<String>,
}

impl Dput {
    pub fn new(dput_target: Option<String>) -> Self {
        Self { dput_target }
    }
}

impl ActionImpl for Dput {
    fn execute(&self, context: &Context) -> Result<(), ActionError> {
        if let Some(target) = &self.dput_target {
            let changes = changes_file(context.artifacts_dir())?;
            dput(target, &changes)?;
        }
        Ok(())
    }
}
