#![allow(clippy::result_large_err)]

use log::info;
use serde::{Deserialize, Serialize};

use crate::{
    action::{ActionError, Context, Pair},
    action_impl::ActionImpl,
    util::http_get_to_file,
};

#[derive(Debug, Clone, PartialEq, Eq, Serialize, Deserialize)]
pub struct HttpGet {
    items: Vec<Pair>,
}

impl HttpGet {
    pub fn new(items: Vec<Pair>) -> Self {
        Self { items }
    }

    pub fn items(&self) -> &[Pair] {
        &self.items
    }
}

impl ActionImpl for HttpGet {
    fn execute(&self, context: &Context) -> Result<(), ActionError> {
        let deps = context.deps_dir();
        info!("http_get: deps={}", deps.display());
        for pair in self.items.iter() {
            let filename = deps.join(pair.filename());
            http_get_to_file(pair.url(), &filename)
                .map_err(|err| ActionError::Get(pair.url().to_string(), err))?;
        }
        Ok(())
    }
}
