use log::info;
use serde::{Deserialize, Serialize};

use crate::{
    action::{ActionError, Context},
    action_impl::ActionImpl,
};

#[derive(Debug, Clone, PartialEq, Eq, Serialize, Deserialize)]
pub struct Pwd;

impl ActionImpl for Pwd {
    fn execute(&self, context: &Context) -> Result<(), ActionError> {
        let path = context.source_dir();
        let path = path
            .canonicalize()
            .map_err(|err| ActionError::Canonicalize(path.to_path_buf(), err))?;
        info!("cwd: {}", path.display());
        Ok(())
    }
}
