#![allow(clippy::result_large_err)]

use serde::{Deserialize, Serialize};

use crate::{
    action::{ActionError, Context},
    action_impl::{spawn, ActionImpl},
};

/// Execute a snippet of shell script.
///
/// The snippet is executed using `bash`, with `set -xeuo pipefail` to make
/// it fail if any command fails, or an unset variable is used, and to trace
/// execution to allow easier debugging.
#[derive(Debug, Clone, PartialEq, Eq, Serialize, Deserialize)]
pub struct Shell {
    shell: String,
}

impl Shell {
    pub fn new(shell: String) -> Self {
        Self { shell }
    }
}

impl ActionImpl for Shell {
    fn execute(&self, context: &Context) -> Result<(), ActionError> {
        let snippet = format!("set -xeuo pipefail\n{}\n", self.shell);
        spawn(
            context,
            &["/bin/bash", "-c", &snippet],
            context.source_dir(),
        )?;
        Ok(())
    }
}
