# Introduction

Ambient does automated [continuous integration][] for programmers in a safe and secure way.
That means it builds the software and runs its automated tests,
but prevents the software under test from harming the host it runs on.
Ambient achieves this by only running code from the software under test,
or any of its dependencies,
in a virtual machine without network access,
and only the resources configured by the Ambient user.


[continuous integration]: https://en.wikipedia.org/wiki/Continuous_integration


# Installation

See [`INSTALL.md`](https://app.radicle.xyz/nodes/radicle.liw.fi/rad:zwPaQSTBX8hktn22F6tHAZSFH2Fh/tree/INSTALL.md)
in the source tree.


# Getting started

## Built-in help

The `ambient` command has extensive built in help: give the `-h` or `--help` option to the command,
or any sub-command,
or use `help` sub-command:

~~~
ambient -h
ambient --help
ambient run --help
ambient help
ambient help run
~~~

## Projects file

To run CI on a project using Ambient, you need to create a "projects file".

~~~yaml
projects:
  dummy:
    image: /scratch/ambient-images/ambient-boot.qcow2
    source: ~/pers/ambient-ci/ambient-ci
    pre_plan:
      - action: cargo_fetch
    plan:
      - action: cargo_clippy
      - action: cargo_build
      - action: cargo_doc
      - action: cargo_test
~~~

The projects file, in YAML, specifies the projects Ambient should know about.
For each project:

* `image` is the virtual machine image to use
  - a custom image is published at [`files.liw.fi`](https://files.liw.fi/ambient/)
* `source` is the path to the source directory of the project
  - it can be, but does not need to be, a Git checkout
* `pre_plan`, `plan`, and `post_plan` are lists of actions to execute for a CI run
  - `pre_plan` actions are executed before the VM starts
  - `plan` actions are executed inside the running VM
  - `post_plan` actions are executed after the VM finishes

In each kind of plan, only specific actions are allowed.
For `pre_plan`, the following are allowed:

* `cargo_fetch` - download Rust crate dependencies for the software under test
* `http_get` - download specific files from URLs

For `plan`:

* `cargo_fmt`, `cargo_clippy`, `cargo_deny`, `cargo_doc`, `cargo_build`, `cargo_test`
  `cargo_install` - run the corresponding `cargo` command
* `deb` - build a `deb` package
* `custom` - run an executable action from `.ambient` in the root of the source tree

For `post_plan`:

* `dput` - upload built `deb` packages to an APT repository
* `rsync` - upload built artifact files to a server using `rsync`

For post-plan actions, the credentials of the user running `ambient` are used.

## Configuration

You should configure Ambient by creating `~/.config/ambient/config.yaml`
(the location obeys the [XDG base directory spec](https://specifications.freedesktop.org/basedir/latest/)):

~~~yaml
tmpdir: /scratch/tmp
projects: ~/liw-dot-files/ambient.yaml
target: "_ewww@webby:/srv/http"
dput_target: apt.liw.fi
executor: /scratch/cargo-cache/x86_64-unknown-linux-musl/debug/ambient-execute-plan
artifacts_max_size: 1G
cache_max_size: 50G
state: /scratch/ambient-state
qemu:
  cpus: 8
  memory: 16G
~~~

The fields are:

* `tmpdir` - location where Ambient temporary files are put
  - these can get quite large, so it can be necessary to override the default `$TMPDIR`
* `projects` - path to the projects file
* `target` - where the `rsync` action uploads files over SSH
* `dput_target` - where `deb` packages are uploaed using `dput`
* `executor` - the `ambient-execute-plan` program suitable for the VM used
* `artifacts_max_size`, `cache_max_size` - how big the artifacts and cache directories can grow
* `state` - location where Ambient keeps pre-project state
* `qemu.cpus`, `qemu.memory` - number of CPUs and memory to give to the VM

Some of those are optional, as they have defaults.
To see the actual run-time configuration used by `ambient`, run:

~~~
ambient config
~~~

You can specify the configuration file to use with the `--config` option.

## Run Ambient

Given an image and a projects file, run Ambient using a command like this:

~~~
ambient run 
~~~

This runs CI for every project in the projects file, if the project source code has changed.
Add the `--force` option to force CI to run.

Any output to the standard output and error from any of the actions is written to the standard output
and gathered in a "run log".
The run log can be viewed later with

~~~
ambient log dummy
~~~

The run log is, for now, quite messy.
