#![allow(clippy::result_large_err)]

use ambient_ci::{linter, plan::PlanError};

use super::Config;
pub trait Leaf {
    fn run(&self, config: &Config) -> Result<(), AmbientDriverError>;
}

pub mod actions;
pub mod config;
pub mod image;
pub mod log;
pub mod plan;
pub mod projects;
pub mod qemu;
pub mod run;

#[derive(Debug, thiserror::Error)]
pub enum AmbientDriverError {
    #[error(transparent)]
    Action(#[from] actions::ActionError),

    #[error(transparent)]
    Config(#[from] config::ConfigError),

    #[error(transparent)]
    Image(#[from] image::ImageError),

    #[error(transparent)]
    Log(#[from] log::LogError),

    #[error(transparent)]
    PlanCmd(#[from] plan::PlanError),

    #[error(transparent)]
    Projects(#[from] projects::ProjectsCmdError),

    #[error(transparent)]
    Qemu(#[from] qemu::QemuCmdError),

    #[error(transparent)]
    Run(#[from] run::RunError),

    #[error(transparent)]
    Linter(#[from] linter::LinterError),

    #[error(transparent)]
    Plan(#[from] PlanError),
}
