# Install Ambient

To use Ambient, you need:

* the `ambient` executable for your host
* the `ambient-execute-plan` executable for your virtual machine
* a virtual machine image
* QEMU system emulator for the virtual machine
* The `qemu-img` program, part of QEMU.
* The `xorrisofs` program.

## On Debian and derivative Linux distributions

* Install the Rust toolchain.
  - see <https://www.rust-lang.org/tools/install>
  - the Debian packages may or may not work

* Install necessary packages.

  - `build-essential` (needed for Rust tool chain)
  - `qemu-utils`
  - `qemu-system-x86`
  - `xorriso`

* Enable Linux kernel hardware virtual machine support, known as KVM.
  This improves performance, but is not otherwise strictly necessary.
  In some cases, it's enough to add your user to the `kvm` group.

* Install the Ambient binaries to the usual location. Make sure that
  location is in your `$PATH`. This installs the latest release of
  Ambient, and the `ambient` and `ambient-execute-plan`
  binaries.

~~~sh
cargo install ambient
ambient --version
~~~

* The second command should output something like `ambient
  0.1.0`

* Create `~/.config/ambient/config.yaml`, like below, but
  adjust values to fit your system. The fields that control resource
  use are especially important: `cpus`, `memory`,
  `artifacts_max_size`, `cache_max_size`, but the `target` and
  `dput_target` fields are also important, for security

~~~yaml
tmpdir: /tmp
projects: ~/ambient.yaml
executor: ~/.cargo/bin/ambient-execute-plan
qemu:
  cpus: 2
  memory: 2G
  kvm_binary: /usr/bin/kvm
  ovmf_vars_file: /usr/share/ovmf/OVMF.fd
  ovmf_code_file: /usr/share/ovmf/OVMF.fd
artifacts_max_size: 1G
cache_max_size: 1G
~~~

* Verify the configuration file is found and works:

~~~sh
ambient config
~~~

* Download and un-compress a pre-made Debian x86_64 virtual machine
  image. Ambient requires an image to run a VM. The image must have
  all dependencies pre-installed. The Ambient project provides a large
  image that's sufficient for Ambient development, and is OK to start
  with. You can later also build your own image.
  - <https://files.liw.fi/ambient/>
  - `curl -s https://files.liw.fi/ambient/ambient.qcow2.xz | unxz -v > ambient.qcow2`

* Create a projects file. You need this to verify Ambient works. Put
  this in the location specified in the configuration file.

~~~yaml
projects:

  demo:
    image: ~/ambient.qcow2
    source: ~/.config/ambient
    plan:
      - action: shell
        shell: |
          echo hello, world
~~~

* Verify that Ambient works.

~~~sh
AMBIENT_LOG=info ambient run demo
ambient log demo
~~~

* The second command should produce a lot of output, but it should
  include something like this:

~~~
RUN: Shell {
    shell: "echo hello, world\n",
}
SPAWN: argv=["/bin/bash", "-c", "set -xeuo pipefail\necho hello, world\n\n"]
       cwd=/workspace/src (exists? true)
       extra_env=[]
+ echo hello, world
hello, world
~~~

* If this works, Ambient works.

## Other operating systems

FIXME. I don't use other operating systems enough to write these
instructions, sorry.
