use serde::{Deserialize, Serialize};

use crate::{
    action::{ActionError, Context},
    action_impl::ActionImpl,
};

/// A dummy action that does nothing.
///
/// This is meant for testing serialization and other parts of Ambient.
#[derive(Debug, Clone, PartialEq, Eq, Serialize, Deserialize)]
pub struct Dummy;

impl ActionImpl for Dummy {
    fn execute(&self, context: &mut Context) -> Result<(), ActionError> {
        context.runlog().debug("dummy action");
        Ok(())
    }
}
