# Ambient - a CI engine

See <https://ambient.liw.fi/> for more information.

## Feedback and contributions

The Radicle repository (`rad:zwPaQSTBX8hktn22F6tHAZSFH2Fh`) is my
preferred way to get feedback in the form of issue tickets or patches.
However, the codeberg.org repository
(<https://codeberg.org/ambient/ambient-ci>) is also OK. Or mention me
on the fediverse (`@liw@toot.liw.fi`) or send me email.


## Build and run tests

To build the code and to run the test suite:

~~~
make
~~~

The `Makefile` targets `build` and `test` can be used to do only part
of that.


## Dependencies

You'll need, at least, with package names as they're in Debian:

* [Subplot](https://subplot.tech/) (not packaged in Debian)
* `python`
* `python3-yaml`
* `qemu-utils` (specifically `qemu-img`)
* `ovmf` (UEFI implementation for virtual machines)
* `qemu-system-x86` (specifically `kvm`)
* `rsync`


## On logging

Logging is communication and has audiences. Communication needs to be suitable
for what it tries to convey and what each audience needs. For Ambient, the
audiences are, roughly:

* the software developer whose project is being built and tested in CI
  - they mostly want to know if something failed under CI that was caused by their code
  - for example, if their code has a syntax error or a test failed
* the sysadmin who runs Ambient
  - they mostly want to know if Ambient is misbehaving, such as a disk being
    full
* the Ambient developers
  - they mostly want to know Ambient works as intended, e.g., in Ambient's own test suite

These are served by different kinds of logging.

* the developer needs the run log, with everything that Ambient did during the
  CI run for their project, and what the result was, with enough detail that
  they can usually figure out what the problem is, if an action fails
  - they also don't want to be overwhelmed by a lot of uninteresting detail
* the sysadmin can also be served by the run log, although they may care about
  other parts and details than the developer
* the Ambient developer needs some kind of log that the test suite can analyze

Status quo for logging:

* Ambient itself (`ambient`) produces a JSON Lines format run log (`run.log`
  in the project state directory). In the VM, the `ambient-execute-plan` does
  as well, but that output can be surrounded by non-JSON junk produced by,
  for example, the VM BIOS at boot. When the VM is shut down, `ambient` parses
  the output from the VM (captured via a serial port), and extracts the JSON
  parts, and outputs those to its own JSON log.

* The JSON Lines log is postprocessed (`ambient log --html`) into an HTML
  page. This is what developers and sysadmins are meant to actually read. The
  HTML log will probably need to be customized for some audiences, but having
  the JSON Lines format available makes that tolerably easy.

* The output captured from the VM serial port is stored in raw format
  (`raw.log` in the project state directory). This may be helpful in special
  cases.

These should cover everything except the needs of the test suite.

The test suite primarily needs to know what actions are run, including in pre-
and post-plan. In principle that is captured in the JSON Lines log. There's
also a need to see that `--dry-run` works. That doesn't end up in a run log:
the log isn't created for a dry run. For that specific case, `ambient` will
output a line to stderr.


## Legalese

(See [`COPYING.md`](COPYING.md) for a copy of the license.)

Any changes made in September, 2025, or later, by Lars Wirzenius, are
copyright Better Internet Foundation.

Copyright 2023  Lars Wirzenius, Better Internet Foundation, and others

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
