use std::{error::Error, path::Path};

use ambient_ci::plan::RunnablePlan;

const PLAN_FILENAME: &str = "plan.yaml";

fn main() {
    if let Err(err) = fallible_main() {
        eprintln!("ERROR: {err}");
        let mut source = err.source();
        while let Some(src) = source {
            eprintln!("caused by: {}", src);
            source = src.source();
        }
        std::process::exit(1);
    }
}

fn fallible_main() -> Result<(), Box<dyn std::error::Error>> {
    println!("ambient-execute-plan starts");
    let plan = RunnablePlan::from_file(Path::new(PLAN_FILENAME))?;
    for action in plan.iter() {
        println!("RUN: Action {:#?}", action);
        let result = action.execute(&plan);
        match &result {
            Ok(()) => println!("RUN: Action finished OK"),
            Err(err) => {
                println!("ERROR: Action failed: {err}");
                let mut source = err.source();
                while let Some(src) = source {
                    println!("caused by: {}", src);
                    source = src.source();
                }
            }
        }
        result?
    }
    println!("ambient-execute-plan ends");

    Ok(())
}
