use clap::Parser;

use super::{AmbientDriverError, Config, Leaf};

/// Show configuration to user.
#[derive(Debug, Parser)]
pub struct ConfigCmd {
    #[clap(long)]
    oneline: bool,
}

impl Leaf for ConfigCmd {
    fn run(&self, config: &Config) -> Result<(), AmbientDriverError> {
        let json = if self.oneline {
            serde_json::to_string(config).map_err(ConfigError::ToJson)?
        } else {
            serde_json::to_string_pretty(config).map_err(ConfigError::ToJson)?
        };
        println!("{}", json);
        Ok(())
    }
}

#[derive(Debug, thiserror::Error)]
pub enum ConfigError {
    #[error("failed to serialize configuration to JSON")]
    ToJson(#[source] serde_json::Error),
}
