use std::path::Path;

use log::{debug, error, info, trace, warn, LevelFilter};

use ambient_ci::plan::RunnablePlan;

const PLAN_FILENAME: &str = "plan.yaml";

fn main() {
    if let Err(err) = fallible_main() {
        eprintln!("ERROR: {err}");
        let mut source = err.source();
        while let Some(src) = source {
            eprintln!("caused by: {src}");
            source = src.source();
        }
        std::process::exit(1);
    }
}

fn fallible_main() -> Result<(), Box<dyn std::error::Error>> {
    setup_logger("AMBIENT_LOG", LevelFilter::Trace);
    trace!("ambient-execute-plan version {} starts", env!("VERSION"));
    debug!("ambient-execute-plan version {} starts", env!("VERSION"));
    info!("ambient-execute-plan version {} starts", env!("VERSION"));
    warn!("ambient-execute-plan version {} starts", env!("VERSION"));
    error!("ambient-execute-plan version {} starts", env!("VERSION"));

    let plan = RunnablePlan::from_file(Path::new(PLAN_FILENAME))?;
    plan.execute()?;
    println!("ambient-execute-plan ends");

    Ok(())
}

fn setup_logger(var: &str, default_level: LevelFilter) {
    // Create a log builder from the environment.
    let mut builder = env_logger::Builder::from_env(var);

    // If there is no environment to build from, set default log
    // level.
    if std::env::var(var).is_err() {
        builder.filter_level(default_level);
    };

    builder.init();
}
