# Release notes for Ambient CI

This file summarizes the user-visible changes to `ambient-ci`
between releases.

## Version 0.9.0, released 2025-11-13

* The `http_get` action now uses the `If-Modified-Since` HTTP request
  header correctly. This means it won't re-download a file unless it has
  changed on the server.

* Actions in `plan` now have the `HOME` environment variable set. It set by
  the `ambient-execute-plan` when it executes the actions.

## Version 0.8.0, released 2025-10-01

Breaking changes:

* It is now an error for the runnable plan given to `ambient-execute-plan`  to
  have unknown fields. This is technically a breaking change, but should not
  actually break any valid use. The only people affected should be those who
  write or generate their runnable plans without `ambient`. The change was made
  to make problems in the runnable plan more explicit.

Brown paper bag bug fixes:

* `ambient` now fails a run if an action in the VM fails. This was always
  meant to be the case, but broke at some point. There is now an explicit
  acceptance criterion to verify this doesn't break again.

New features:

* The option `ambient plan --yaml` was added to output the plan, as loaded
  into memory by `ambient`, in the YAML format. The default is JSON, added
  for the sake of testing. The YAML output should help those who want to have
  something they can rely on being at least syntactically correct.

* The option `ambient plan --runnable` was added to generate and output the
  runnable plan for a project. This should help those who want to play with
  `ambient-execute-plan` outside a VM.

* The action `cargo_deny` to run `cargo deny` has been added.


## Version 0.7.0, released 2025-09-19

* All actions get the environment variables to use the Rust toolchain.
  This change will eventually make it easier to have actions that set
  environment variables for later actions, but that has not yet been
  implemented.

* `ambient-execute-plan` now logs its own version at startup. This is
  helpful for troubleshooting why fixes to it don't work in tests. (It's
  usually because the tests use the wrong version of the program.)

## Version 0.6.0, released 2025-09-19

* The `cargo_fetch` actions now runs with the `--locked` option only
  if the `Cargo.lock` file exists.

* All actions that run `cargo` or `rustc` log their versions.

* New pre-plan action `http_get` allows downloading files into the
  dependencies before the VM start.

* New action `cargo_doc` verifies that Rust documentation comments can
  be formatted.

* Run log now contains stdout and stderr of any programs run by
  actions. This especially affects `tar_extract` and `tar_create`
  actions and will make it visible when creating a tar archive from,
  say, the cache directory fails due to a full disk.

* License is now clarified to be GNU GPL version 3 or later.
  Previously it was that and AGPL version 3.

## Version 0.5.2, released 2025-09-10

* If QEMU fails, log its stderr.

## Version 0.5.1, released 2025-08-12

* This release fixes a bug in the new `custom` action. The action is
  now run in the source directory.

## Version 0.5.0, released 2025-08-12

* A new, experimental action `custom` has been added. It can be used
  in `plan`, so that it is only available in the VM. The action
  executes a program in the `.ambient` directory at the root of the
  source tree. This is a first step towards user-provided action
  implementations.

## Version 0.4.0, released 2025-07-20

Breaking changes:

* Ambient now uses `xorriso` instead of `genisoimage` to generate an
  ISO file as a `cloud-init` local data storage. This is a breaking
  changes, as `genisoimage` is not used even if available. Thank you
  to Tobias Hunger.

Other changes:

* The way Ambient invokes QEMU is now more configurable, thanks to
  Tobias Hunger. The configuration file now has a field `qemu` with
  fields``cpu`, `memory`, `kvm_binary`, `ovmf_vars_file`, and
  `ovmf_code_file` can be set. Of these, `cpus` and `memory` were
  possible to set at the top level of the configuration file from
  before. They still can be, to avoid breaking backwards
  compatibility. The new fields take precedence.
  
* QEMU is now invoked with strict boot mode, system UUID, hostname,
  and other improved settings, thanks to Tobias Hunger.

* The `target` configuration file setting is now known as
  `rsync_target`, for clarity. Likewise the option `--target` is now
  known as `--rsync-target`. The old names also work.

* There is now a new configuration file setting `rsync_target_base`,
  to which the project name is joined, if `rsync_target` is not set.
  This allows the same base target to be used for a family of projects
  that publish their artifacts to sibling directories.
  
  There is also a setting `rsync_target_map` to allow setting the
  rsync target URL for each project separately. This is for
  convenience.
  
* The `tmpdir` setting now defaults to `TMPDIR` in the environment, if
  that is set.

* The `--config` option can be used many times, to allow many
  configuration files to be loaded. This is for flexibility.

* The `--no-config` option prevents the default configuration from
  being loaded.

* The `--version` outputs a version number, which now includes the Git
  commit of the sources. This is to enable better remote support.

* There is some preliminary sketches of an `ambient image` group of
  subcommands for managing a library of virtual machine images. This
  is not really usable yet, however, because Lars Wirzenius wasn't
  able to dedicate enough time to complete this work. It was merged,
  and thus included in this release, so that it doesn't bit rot in an
  abandoned branch.

* The `tar_extract` action now lists the files that are extracted. The
  action can only be used in the plan, not in the pre- or post-plans.

* The `ambient plan` command outputs the pre-, post-, and actual plans
  for a CI run for a project. This is meant to provide visibility as
  to what happens.

* There are various improvements to what gets logged, but log files
  are still mostly only useful to those familiar with the source code.

## Version 0.3.0, released 2025-04-17

* The error message for when running `qemu-img` fails now mentions
  `qemu-img`. Previously the error was only "File not found", which is
  not very useful to the user.

* The error message for being unable to read a log file now mentions
  the name of the log file. This, too, is meant to be useful to users,
  when there's a problem.

* The result of `ambient-execute-plan` running an action in the
  virtual machine is now shown explicitly. Previously the success of
  executing an action was not logged, it was implicit in that the run
  didn't end in failure.

* The `cargo_fetch`, `cargo_clippy`, and `cargo_build` actions now
  don't use the `-vvv` option, which tells Cargo to be very, very,
  very verbose. This is to make run logs be of a tolerable size and
  not hide problems under a mountain of text. In the long term,
  Ambient should produce logs where that kind of verbosity can be
  controlled at reading time.

* The default log level for `ambient` is not `info`, previously
  `warn`. This makes running the command a little more verbose. The
  log level can be controlled with the `AMBIENT_LOG` environment
  variable.

* When `ambient` makes a copy of the OVMF file (part of the UEFI
  implementation for virtual machines) it now gives the user who runs
  `ambeint` write permission to the copy.

* The `ambient image import` command now has a progress bar. Importing
  computes a SHA256 checksum, which can take a while, and the progress
  bar keeps the user amused.

* The `README.md` file now mentions how to build the code and run the
  tests (TL;DR: `make`), and what build time dependencies are needed
  for this.


## Version 0.2.0, released 2025-03-17

There are no big changes, except the name change. The purpose of this
release is to update the Rust crate with the new name.

* Installation documentation are now included in the file
  `INSTALL.md`. They aren't verified automatically, but did work when
  tested manually at the time they were written.

* The binary has been renamed to `ambient`. The Rust crate has been
  renamed to `ambient-ci`. The primary source code repository has been
  moved to Radicle (repository id `rad:zwPaQSTBX8hktn22F6tHAZSFH2Fh`),
  but the old Codeberg location will continue to work.

## Version 0.1.0, released 2025-01-09

The first release. This was released under the name `ambient-driver`,
because Lars didn't think clearly.
