import os


def install_ambient_driver(ctx):
    runcmd_prepend_to_path = globals()["runcmd_prepend_to_path"]
    srcdir = globals()["srcdir"]

    # Add the directory with built Rust binaries to the path.
    default_target = os.path.join(srcdir, "target")
    target = os.environ.get("CARGO_TARGET_DIR", default_target)
    runcmd_prepend_to_path(ctx, dirname=os.path.join(target, "debug"))
    ctx["binary"] = os.path.join(target, "debug", "ambient-driver")
    ctx["run-ci"] = os.path.join(target, "debug", "run-ci")

    shutil.copy(ctx["run-ci"], "run-ci")
    assert os.path.exists("run-ci")


def install_vm_image(ctx, filename=None):
    assert "/" not in filename

    image = os.environ.get("IMAGE")
    if image is None:
        raise Exception("set IMAGE in environment to path to Ambient image to use")
    if not os.path.exists(image):
        raise Exception("$IMAGE MUST point to an existing file")

    os.symlink(image, filename)
