use std::path::Path;

use ambient_driver::plan::Plan;

const PLAN_FILENAME: &str = "plan.yaml";

fn main() -> anyhow::Result<()> {
    println!("run-ci starts");
    let plan = Plan::from_file(Path::new(PLAN_FILENAME))?;
    for action in plan.iter() {
        println!("RUN: {:#?}", action);
        action.execute()?;
    }
    println!("run-ci ends");
    Ok(())
}
