# Introduction

`ambient-driver` is a prototype for running CI on a project, using
`ambient-run`.

# Smoke test

_Requirement:_ The `ambient-driver` tool can show it's runtime
configuration.

_Justification:_ If this doesn't work, there's no hope of anything
else working, either.

_Stakeholder:_ Lars


~~~scenario
given an installed ambient-driver
given file .config/ambient-driver/config.yaml from config.yaml
when I run ambient-driver config
then stdout contains "ambient.log"
~~~

~~~{#config.yaml .file .yaml}
log: ambient.log
run_ci: run-ci
~~~

# Allows specifying a configuration file

_Requirement:_ The `ambient-driver` tool allows the user to specify
which configuration file to use.

_Justification:_ This is very convenient when one wants to try things
and temporarily not use the default configuration file. This happens
both for experimentation and for testing.

_Stakeholder:_ Lars


~~~scenario
given an installed ambient-driver
given file special.yaml
when I run ambient-driver --config special.yaml config
then stdout contains "special.log"
~~~

~~~{#special.yaml .file .yaml}
log: special.log
run_ci: run-ci
~~~

# Capture build log when running

_Requirement:_ The stdout/stderr output of the commands executed by
the CI run must be captured.

_Justification:_ This is the primary way for the user to know what
happened during a run.

_Stakeholder:_ Lars.

Note that we can't use `.` for the current directory as the `source`
field in the project file due to how Subplot sets up a temporary data
directory for each scenario, and sets `TMPDIR` to that directory.
This would mean that `.` as `source` would create a tar archive in the
temporary directory that tries to add itself, which creates an
infinitely large tar archive.

~~~scenario
given an installed ambient-driver
given an Ambient VM image ambient.qcow2
given file .config/ambient-driver/config.yaml from config.yaml
given file hello.yaml
given a directory srcdir
when I run env AMBIENT_LOG=trace ambient-driver run hello.yaml
then file ambient.log contains "well hello there, friend"
~~~

~~~{#hello.yaml .file .yaml}
projects:
  hello:
    image: ambient.qcow2
    source: srcdir
    plan:
    - action: shell
      shell: |
        echo well hello there, friend
~~~

# Relative filenames in project files

_Requirement:_ When a project file has a relative filename, it's
relative to the directory containing the project file.

_Justification:_ The user can then run `ambient-driver run` from
anywhere, not just the source directory.

_Stakeholder:_ Lars.

~~~scenario
given an installed ambient-driver
given file .config/ambient-driver/config.yaml from config.yaml
given a directory path/to/project/srcdir
given an Ambient VM image ambient.qcow2
when I run mv ambient.qcow2 path/to/project/
given file path/to/project/hello.yaml from hello.yaml
when I run env AMBIENT_LOG=trace ambient-driver run path/to/project/hello.yaml
then file ambient.log contains "well hello there, friend"
~~~

# Working directory in pre- and post-plan actions

_Requirement:_ When a pre- or post-plan action is executed, the
current working directory should be the source directory.

_Justification:_ Many actions can only usefully be executed in the
source directory.

_Stakeholder:_ Lars.

Note that we can't use `.` for the current directory as the `source`
field in the project file due to how Subplot sets up a temporary data
directory for each scenario, and sets `TMPDIR` to that directory.
This would mean that `.` as `source` would create a tar archive in the
temporary directory that tries to add itself, which creates an
infinitely large tar archive.

~~~scenario
given an installed ambient-driver
given file .config/ambient-driver/config.yaml from config.yaml
given an Ambient VM image ambient.qcow2
given file cwd.yaml
given a directory path/to/project/srcdir
when I run env AMBIENT_LOG=ambient_driver::action=trace ambient-driver run cwd.yaml
then stderr matches regex INFO.*cwd:.*/path/to/project/srcdir
~~~

~~~{#cwd.yaml .file .yaml}
projects:
  pwd:
    image: ambient.qcow2
    source: path/to/project/srcdir
    pre_plan:
    - action: pwd
    post_plan:
    - action: pwd
    plan:
    - action: shell
      shell: |
        pwd
~~~

# Run CI only for some projects

_Requirement:_ When the projects file has more than one project, user
can choose only specific ones to run CI for.

_Justification:_ User may be only interested in one project right now.

_Stakeholders:_ Lars

~~~scenario
given an installed ambient-driver
given file .config/ambient-driver/config.yaml from config.yaml
given an Ambient VM image ambient.qcow2
given file multi.yaml
given a directory foo
given a directory bar
when I run env AMBIENT_LOG=debug ambient-driver run --dry-run multi.yaml foo
then stderr contains "project foo: NOT running CI"
then stderr doesn't contain "project bar:"
~~~

~~~{#multi.yaml .file .yaml}
projects:
  foo:
    image: ambient.qcow2
    source: foo
    plan:
    - action: shell
      shell: |
        echo foo project
  bar:
    image: ambient.qcow2
    source: bar
    plan:
    - action: shell
      shell: |
        echo bar project
~~~
# List names of projects

_Requirement:_ The user can list names of projects in a projects file.

_Justification:_ This is handy for checking and scripting.

_Stakeholders:_ Lars

~~~scenario
given an installed ambient-driver
given file .config/ambient-driver/config.yaml from config.yaml
given an Ambient VM image ambient.qcow2
given file multi.yaml
given a directory foo
given a directory bar
when I run ambient-driver projects multi.yaml
then stdout is exactly "bar\nfoo\n"
~~~

# List names of actions

_Requirement:_ The user can list names of projects in a projects file.

_Justification:_ This is handy for checking and scripting.

_Stakeholders:_ Lars

~~~scenario
given an installed ambient-driver
given file .config/ambient-driver/config.yaml from config.yaml
given an Ambient VM image ambient.qcow2
when I run ambient-driver actions
then stdout contains "pre_actions:\n"
then stdout contains "\nactions:\n"
then stdout contains "\npost_actions:\n"
~~~
# Cache persists between CI runs

_Requirement:_ Cache data is persisted between CI runs.

_Justification:_ This allows incrementally building a project after
changes.

_Stakeholders:_ Lars

~~~scenario
given an installed ambient-driver
given file .config/ambient-driver/config.yaml from config.yaml
given an Ambient VM image ambient.qcow2
given file cache.yaml
given a directory srcdir

when I run ambient-driver run cache.yaml
then file ambient.log contains "counter is now 1."

when I run ambient-driver run cache.yaml
then file ambient.log contains "counter is now 2."

when I run ambient-driver run cache.yaml
then file ambient.log contains "counter is now 3."
~~~

~~~{#cache.yaml .file .yaml}
projects:
  hello:
    image: ambient.qcow2
    source: srcdir
    plan:
    - action: shell
      shell: |
        cache=/workspace/cache
        counter="$cache/counter"
        if [ -e "$counter" ]; then
            n="$(expr "$(cat "$counter")" + 1)"
            echo "$n" > "$counter"
        else
            echo 1 > "$counter"
        fi
        echo "counter is now $(cat "$counter")."
        find "$cache" -ls
~~~
# Publish files via rsync

_Requirement:_ Artifacts can be published via rsync to a server.

_Justification:_ This allows publishing many kinds of things.

_Stakeholders:_ Lars

~~~scenario
given an installed ambient-driver
given file .config/ambient-driver/config.yaml from config.yaml
given an Ambient VM image ambient.qcow2
given file rsync.yaml
given a directory srcdir
given file srcdir/data.dat from rsync.yaml

given a directory serverdir
when I run ambient-driver run rsync.yaml --target serverdir
then file serverdir/hello.txt contains "hello, world"
~~~

~~~{#rsync.yaml .file .yaml}
projects:
  hello:
    image: ambient.qcow2
    source: srcdir
    plan:
    - action: shell
      shell: |
        echo hello, world > /workspace/artifacts/hello.txt
    post_plan:
    - action: rsync
~~~
