use clap::Parser;
use log::{debug, info};

use ambient_driver::{
    config::{Args, EffectiveConfig},
    run::run,
};

fn main() {
    if let Err(e) = fallible_main() {
        eprintln!("ERROR: {}", e);
        let mut source = e.source();
        while let Some(src) = source {
            eprintln!("caused by: {}", src);
            source = src.source();
        }
        std::process::exit(1);
    }
}

fn fallible_main() -> anyhow::Result<()> {
    let mut builder = pretty_env_logger::formatted_builder();
    builder.filter_level(log::LevelFilter::Info);
    builder.parse_env("AMBIENT_LOG");
    builder.init();

    info!("ambient-driver starts");
    let args = Args::parse();
    let config = EffectiveConfig::try_from(&args)?;
    debug!("{:#?}", config);
    run(&config)?;
    info!("ambient-driver ends successfully");
    Ok(())
}
