import os
import shutil


def install_ambient_driver(ctx):
    runcmd_prepend_to_path = globals()["runcmd_prepend_to_path"]
    srcdir = globals()["srcdir"]

    # Add the directory where the binaries have been installed to PATH.
    bindir = os.environ.get("BINDIR")
    if bindir is None:
        raise Exception("set BINDIR to point to directory with Ambient binaries")
    if not os.path.exists(bindir):
        raise Exception(
            "$BINDIR point to an existing directory: {bindir} does not exist"
        )

    ctx["driver"] = os.path.join(bindir, "ambient-driver")
    ctx["executor"] = os.path.join(bindir, "ambient-execute-plan")
    for bin in [ctx["driver"], ctx["executor"]]:
        if not os.path.exists(bin):
            raise Exception(f"{bin} MUST exist")
        shutil.copy(bin, ".")

    runcmd_prepend_to_path(ctx, dirname=os.path.abspath("."))


def install_vm_image(ctx, filename=None):
    assert "/" not in filename

    image = os.environ.get("IMAGE")
    if image is None:
        raise Exception("set IMAGE in environment to path to Ambient image to use")
    if not os.path.exists(image):
        raise Exception("$IMAGE MUST point to an existing file")

    os.symlink(image, filename)
