use std::path::Path;

use ambient_driver::plan::RunnablePlan;

const PLAN_FILENAME: &str = "plan.yaml";

fn main() {
    if let Err(err) = fallible_main() {
        eprintln!("ERROR: {err}");
        let mut source = err.source();
        while let Some(src) = source {
            eprintln!("caused by: {}", src);
            source = src.source();
        }
        std::process::exit(1);
    }
}

fn fallible_main() -> Result<(), Box<dyn std::error::Error>> {
    println!("ambient-execute-plan starts");
    let plan = RunnablePlan::from_file(Path::new(PLAN_FILENAME))?;
    for action in plan.iter() {
        println!("RUN: {:#?}", action);
        action.execute(&plan)?;
    }
    println!("ambient-execute-plan ends");

    Ok(())
}
