use super::Config;
pub trait Leaf {
    fn run(&self, config: &Config) -> Result<(), AmbientDriverError>;
}

pub mod actions;
pub mod config;
pub mod image;
pub mod log;
pub mod projects;
pub mod run;

#[derive(Debug, thiserror::Error)]
pub enum AmbientDriverError {
    #[error(transparent)]
    Action(#[from] actions::ActionError),

    #[error(transparent)]
    Config(#[from] config::ConfigError),

    #[error(transparent)]
    Image(#[from] image::ImageError),

    #[error(transparent)]
    Log(#[from] log::LogError),

    #[error(transparent)]
    Projects(#[from] projects::ProjectsCmdError),

    #[error(transparent)]
    Run(#[from] run::RunError),
}
