use clap::Parser;

use explain_wait_status::Explained;

fn main() {
    let args = Args::parse();
    let explained = Explained::new(args.status);
    println!("{}", serde_json::to_string_pretty(&explained).unwrap());
}

/// Explain the wait status of a terminated process.
#[derive(Parser)]
struct Args {
    /// The wait status.
    status: i32,
}
