//! Fundamental components for implementing backup software.
//!
//! This is the third generation of Obnam. The first two generations
//! were backup software. This generation is an exploration of how the
//! fundamental components of backup software can be implemented well.
//! This is not a backup program, but it may some day grow into one.
//! For now, it's a fun hobby project for me to think about how to
//! implement backup software.

#![deny(missing_docs)]

pub mod chunk;
pub mod cipher;
pub mod client;
pub mod config;
pub mod credential;
pub mod plaintext;
pub mod sop;
pub mod store;
pub mod util;
