import json
import os
import subprocess


def install_obnam(ctx):
    runcmd_prepend_to_path = globals()["runcmd_prepend_to_path"]
    srcdir = globals()["srcdir"]

    default_target = os.path.join(srcdir, "target")
    target = os.environ.get("CARGO_TARGET_DIR", default_target)
    bindir = os.path.join(target, "debug")
    assert os.path.exists(os.path.join(bindir, "obnam"))
    runcmd_prepend_to_path(ctx, dirname=bindir)


def stdout_is_json(ctx):
    runcmd_get_stdout = globals()["runcmd_get_stdout"]
    output = runcmd_get_stdout(ctx)
    try:
        json.loads(output)
    except json.JSONDecodeError as e:
        print("stdout it not valid JSON: error at {e.lineno}:{e.colno}: {e.msg}")
        raise


def file_named_in_file_exists(ctx, filename=None):
    files_relative = globals()["files_relative"]
    files_file_exists = globals()["files_file_exists"]

    filename = files_relative(filename)
    with open(filename) as f:
        filename = f.read()
    files_file_exists(ctx, filename)
