# pathdedup - de-duplicate the PATH environment variable

With a complicated Unix shell setup, the `PATH` environment variable
can end up being long, with many components. `pathedup` outputs an
equivalent value for `PATH`, but with duplicate entries removed.


## Example

~~~
$ echo "$PATH"
/sbin:/usr/sbin:/bin:/usr/bin
$ pathdedup
/sbin:/bin
~~~

In this case, `/bin` is a symbolic link to `/usr/bin`, so only `/bin`
is kept.
