{
  description = "emulate Radicle CI runs locally";

  inputs = {
    nixpkgs.url = "github:NixOS/nixpkgs/release-24.11";

    crane.url = "github:ipetkov/crane";

    flake-utils.url = "github:numtide/flake-utils";

    rust-overlay = {
      url = "github:oxalica/rust-overlay";
      inputs.nixpkgs.follows = "nixpkgs";
    };
  };

  outputs = {
    self,
    nixpkgs,
    crane,
    flake-utils,
    rust-overlay,
    ...
  }:
    flake-utils.lib.eachDefaultSystem (system: let
      lib = nixpkgs.lib;
      pkgs = import nixpkgs {
        inherit system;
        overlays = [(import rust-overlay)];
      };

      rustToolChain = pkgs.rust-bin.fromRustupToolchainFile ./rust-toolchain.toml;
      craneLib = (crane.mkLib pkgs).overrideToolchain rustToolChain;

      src = lib.cleanSourceWith {
        src = ./.;
      };

      basicArgs = {
        inherit src;
        pname = "rad-ci";
        strictDeps = true;
      };

      # Build *just* the cargo dependencies, so we can reuse
      # all of that work (e.g. via cachix) when running in CI
      cargoArtifacts = craneLib.buildDepsOnly basicArgs;

      # Common arguments can be set here to avoid repeating them later
      commonArgs =
        basicArgs
        // {
          inherit cargoArtifacts;

          nativeBuildInputs = with pkgs; [
            # Add additional build inputs here
          ];
          buildInputs = lib.optionals pkgs.stdenv.buildPlatform.isDarwin (with pkgs; [
            darwin.apple_sdk.frameworks.Security
            pkgs.libiconv
          ]);
        };
    in {
      formatter = pkgs.alejandra;

      checks = {
        inherit (self.packages.${system}) rad-ci;

        clippy = craneLib.cargoClippy (commonArgs
          // {
            cargoClippyExtraArgs = "--all-targets -- --deny warnings";
          });

        doc = craneLib.cargoDoc commonArgs;
        fmt = craneLib.cargoFmt basicArgs;
        # Run tests with cargo-nextest
        nextest = craneLib.cargoNextest (commonArgs
          // {
            partitions = 1;
            partitionType = "count";
            # Ensure dev is used since we rely on env variables being
            # set in tests.
            env.CARGO_PROFILE = "dev";
          });
      };

      packages.rad-ci = craneLib.buildPackage (commonArgs
        // {
          src = craneLib.cleanCargoSource ./.;
          strictDeps = true;
          doCheck = false;
        });
      packages.default = self.packages.${system}.rad-ci;

      apps.default = flake-utils.lib.mkApp {
        name = "rad-ci";
        drv = self.packages.${system}.rad-ci;
      };

      devShells.default = craneLib.devShell {
        # Inherit inputs from checks.
        checks = self.checks.${system};

        # Extra inputs can be added here; cargo and rustc are provided by default
        # from the toolchain that was specified earlier.
        packages = with pkgs; [
          cargo-watch
          ripgrep
          rust-analyzer
        ];
      };
    });
}
