# `rad-ci` -- emulate a Radicle CI run locally

`rad-ci` is part of [Radicle CI](https://radicle-ci.liw.fi/).

`rad-ci` makes it easy to see if the current state of the source tree
would pass CI, without committing anything, or pushing to another
node. This is great when you're working a change and want to see if it
would pass the checks done by CI. It's much less waiting than doing it
via the CI server.

See [`rad-ci.md`](rad-ci.md) for a more detailed description.

## Hacking

To build the documentation, and the code, and to run the test suite,
run `make` to get output like this:

~~~sh
$ make
cargo clippy --all-targets -- -Dwarnings
    Checking rad-ci v0.1.0 (/home/liw/radicle/rad-ci)
    Finished `dev` profile [unoptimized + debuginfo] target(s) in 0.07s
cargo build --all-targets
    Finished `dev` profile [unoptimized + debuginfo] target(s) in 0.03s
cargo test --all-targets
    Finished `test` profile [unoptimized + debuginfo] target(s) in 0.01s
     Running unittests src/main.rs (/scratch/cargo-cache/debug/deps/rad_ci-65c077c72ef070e6)

running 0 tests

test result: ok. 0 passed; 0 failed; 0 ignored; 0 measured; 0 filtered out; finished in 0.00s

rm -f test.py test.log
subplot codegen rad-ci.subplot -o test.py
 INFO Starting Subplot
 INFO Subplot finished successfully
SOPASS_LOG=trace python3 test.py --log test.log
srcdir /home/liw/radicle/rad-ci
datadir /tmp/tmpsiailnnk
scenario: Smoke test: reports its version
  step: given an installed rad-ci
  step: when I run rad-ci --version
  step: then stdout matches regex ^rad-ci \\d+\\.\\d+\\.\\d+
OK, all scenarios finished successfully
rm -f test.py test.log
~~~

If the test suite fails, see `test.log`.

Documentation is formatted into `rad-ci.html`.

## License

Radicle native CI is distributed under the terms of both the MIT
license and the Apache License (Version 2.0).

See [LICENSE-APACHE](LICENSE-APACHE) and [LICENSE-MIT](LICENSE-MIT) for details.
