{
  description = "Development environment for a rust project";

  inputs = {
    nixpkgs.url = "github:nixos/nixpkgs/nixos-25.05";
    unstable.url = "github:nixos/nixpkgs/nixos-unstable";
    flake-utils.url = "github:numtide/flake-utils";
    rust-overlay.url = "github:oxalica/rust-overlay";
  };

  outputs = {
    self,
    nixpkgs,
    unstable,
    flake-utils,
    rust-overlay,
  }:
    flake-utils.lib.eachDefaultSystem (system: let
      pkgs = import nixpkgs {
        inherit system;
        overlays = [rust-overlay.overlays.default];
      };
      rust = pkgs.rust-bin.stable."1.89.0".default;
    in {
      # to use other shells, run:
      # nix develop . --command fish
      devShells.default = pkgs.mkShell {
        buildInputs = with pkgs; [
          rust
          lazydocker
          bacon
          cargo-deny
          lefthook
          cocogitto
          just
          gnumake
          pkg-config
          openssl
        ];

        shellHook = ''
          echo "Development environment is ready!"
          cargo -V
        '';
      };

      packages.default = pkgs.writeShellScriptBin "setup-project" ''
        cargo build
      '';
    });
}
