# `radicle-ci-ambient` -- a Radicle CI adapter for Ambient CI

Integrate the [Ambient CI](https://ambient.liw.fi/) software with the
Radicle CI broker.

## Installation and setup

Given a Radicle node with the CI broker:

* Install and configure `ambient` on the host. This will
  require `qemu-system-x86_64` and a virtual machine image.
* Install the Ambient adapter. Below, we assume it's installed as
  `/bin/radicle-ci-ambient` but the location doesn't matter, as long
  as you specify it correctly in the configuration.
* Adjust the CI broker configuration to use the Ambient adapter:

~~~yaml
default_adapter: ambient
adapters:
  ambient:
    command: /bin/radicle-ci-ambient
    env:
      RADICLE_CI_AMBIENT: /home/_rad/radicle-ci-ambient.yaml
      RADICLE_CI_BROKER_WEBROOT: /srv/pages/ci-broker
      PATH: /bin:/home/_rad/.radicle/bin:/home/_rad/.cargo/bin
~~~

  - adjust filenames and `PATH` as necessary
* Restart the CI adapter.
* Make sure that each repository that the node runs CI for, has a CI
  specification file for the Ambient adapter: `.radicle/ambient.yaml`

## Ambient CI specification file

This is also known as a distilled plan. It is YAML, with three fields:

* `pre_plan`
* `plan`
* `post_plan`

Each field is a list of Ambient actions. The pre- and post-plan
actions are run locally on the host, and have network access, but
they're restricted to a small set of variants that are deemed safe and
secure, what Ambient calls [trusted
actions](https://docs.rs/ambient-ci/latest/ambient_ci/action/enum.TrustedAction.html):

- `cargo_fetch`
- `rsync`
- `dput`

The actions in the `plan` are less constrained, but they run in a
virtual machine without network access.

- `mkdir`
- `shell`
- `cargo-fmt`
- `cargo-clippy`
- `cargo-build`
- `cargo-test`
- `cargo-install`
- `deb`

(These need to be documented in Ambient.)

Example:

~~~yaml
pre_plan:
  - action: cargo_fetch
plan:
  - action: cargo_fmt
  - action: cargo_clippy

  - action: shell
    shell: |
      export DEBEMAIL=liw@liw.fi
      export DEBFULLNAME="Lars Wirzenius"
      export CARGO_TARGET_DIR=/workspace/cache

      # git reset --hard
      # git clean -fdx
      # git switch main
      git status --ignored
      # git clean -fdx

      V="$(dpkg-parsechangelog -SVersion | sed 's/-[^-]*$//')"
      T="$(date -u "+%Y%m%dT%H%M%S")"
      version="$V.ci$T-1"
      dch -v "$version" "CI build under Ambient."
      dch -r ''
  - action: deb
~~~

