# Release notes for the Radicle Ambient CI adapter

This file summarizes the user-visible changes to `radicle-ci-ambient`
between releases.

# Version 0.11.5, released 2025-10-01

* This release has no user-visible changes, but depends on
  version 0.8.0 of `ambient-ci`, which adds support for
  the `cargo_deny` action.

# Version 0.11.4, released 2025-09-19

* This release has no user visible changes, but updates its
  dependencies on various crates to work with other components of
  Radicle CI, on which it depends, and to avoid a YAML library issue.

# Version 0.11.3, released 2025-07-28

* Use newly released version of `ambient-ci` to get a fix for the
  `custom` action.

# Version 0.11.2, released 2025-07-28

* The loaded configuration file is not printed to stderr any more.
  It's still logged, and the log may go to stderr, but the log level
  filtering can be controlled by the user.

* The user-visible HTML log of an adapter run now includes all
  `ambient` stdout and stderr output and a table of contents for
  easier navigation.
  
* The adapter now depends on Ambient version 0.5.0 (also released
  today), to bring in support for the `custom` action.

# Version 0.11.1, released 2025-07-28

* Change dependencies on the crates `radicle` and `radicle-ci-broker`
  to current. This avoids having a dependency tree with many versions
  of `AdminLog` for `rad-ci`.

# Version 0.11.0, released 2025-07-28

* The configuration file can now have a field
  `extra_ambient_config_values`, an arbitrary YAML map. This will be
  written to a temporary file, and `ambient` is told to use that file,
  too, when it is run. This is a convenient way to adjust how
  `ambient` is configured from the Ambient adapter.

# Version 0.10.1, released 2025-04-22

* No user visible changes, but dependencies on other Radicle CI
  components have been bumped to their current versions.

# Version 0.10.0, released 2025-04-22

* The adapter can now be configured to use the Radicle repository name
  as the Ambient project name. The default is to use the Radicle
  repository ID. The ID is guaranteed to be unique, the name is not.
  The name is, however, convenient for using the Ambient
  `rsync_trust_base` configuration feature, to allow delivering
  artifacts with the `rsync` action without configuring an target for
  each repository separately.

* The adapter configuration can now specify an extra configuration
  file to give to Ambient. This makes it easier to have different
  Ambient configurations for different CI run. For example, one could
  configure the CI broker so that only a CI run for the default branch
  would allow post-plan Ambient actions.

* The adapter no longer hard codes limits on Ambient cache and
  artifact sizes. Instead, it allows Ambient to use the max sizes in
  its own configuration.

* The output of `--version` now includes the Git commit of the source
  tree when the binary was built. This helps troubleshoot situations
  where people are running a version built from source between
  releases.

* If the adapter creates the project log directory, it now logs that
  to its admin log.

# Version 0.9.0, released 2025-04-22

* Post-plan actions are now only executed if the configuration file
  has `allow_post_plan: true` and are otherwise silently ignored. This
  means it's safer to run CI using Ambient.

* The run log now contains start and end times and duration of the
  run. Also, the repository name is now included in the run log.

# Version 0.8.0, released 2025-03-26

This release merely updates dependencies to current versions. No user
visible changes.

# Version 0.7.0, released 2025-03-17

This release merely updates dependencies to current versions. No user
visible changes.

# Version 0.6.0, released 2025-03-12

The Ambient project renamed its crate and binary. This release adapts
to the name change. No other user visible changes.


# Version 0.5.0, released 2025-03-04

This release has a breaking change, but it's only visible to other
programs that use the Ambient adapter as a code dependency. It's not
visible to users. However, I need to make a release so that I can make
changes to those other programs, which need the change, and need to
depend on a released version of the Ambient adapter.

# Version 0.4.0, released 2025-02-17

* Undo the changes that created a custom configuration file for
  `ambient-driver`. Instead, let it use the its default configuration
  file on the host. This allows a straightforward way to control the
  resources used by the Ambient adapter.

# Version 0.3.0, released 2025-02-14

* The run log now has a copy of the message that triggered the CI run.

* The HTML run log now correctly escapes the textual data from Ambient.

# Version 0.2.2, released 2025-02-03

* Bug fix: fix the log file location again. Clearly this software
  needs automated tests.

# Version 0.2.1, released 2025-02-03

* Bug fix: each CI run now gets its own log file.

# Version 0.2.0, released 2025-02-03

* Bug fix: the Radicle repository ID is now used as the Ambient
  project name. Previously, the run ID was used, but that meant each
  CI run would start from scratch. This meant it would re-download all
  dependencies, and build from scratch. This was wasteful both in
  terms of time, but also space and bandwidth. Now, each CI run is an
  incremental build.

* `README.md` is no longer empty, but includes instructions for use.

# Version 0.l.0, released 2025-01-10

First release.
