---
title: Radicle CI architecture
...

# Overview

CI support in Radicle consists of several components. For native CI
they are:

* the Radicle node
* the CI broker
* the native CI executable

These all run on the same host.

For external CI, the components are:

* the Radicle node
* the CI broker
* an adapter executable for each supported external CI instance
* the external CI instance

The first three of these run on the same host, but the external CI
instance can run anywhere.

The child process is called "the CI adapter" in this document.

CI works like this:

* a repository known to the node changes
  - a git ref is updated
  - the ref can be a branch, tag, or something else, such as a Radicle
    COB
  - the node emits an event describing the change
* the CI broker listens to node event
  - the broker subscribers to node events via the node control socket,
    which is a Unix domain socket
* the CI broker filters events, based on its configuration, and the
  configuration for the repository involved
* for an event that passes its filters, the CI broker spawns the
  adapter process
  - the adapter process is either the native CI engine, or an
    integration with an external CI engine
  - the CI broker uses the executable for native CI by default, but
    this can be overridden by the broker configuration file, and that
    can be overridden by the `.radicle/ci/config.yaml` file in the repository
    the event is for
* the broker sends a request object to the adapter as a child process,
  via the child's stdin, and reads any responses from the child's
  stdout
  - the request is JSON
  - the responses are in the form of JSON Lines: a JSON object per
    line serialized to not contain newline characters

## Native CI

![Sequence diagram for native CI](architecture.svg)

## External CI

![Sequence diagram for external CI](architecture.svg)

# The adapter

The adapter process reads the request to perform a CI run on a
specific commit in a repository, and responds with the id of the run,
then later with the status of the finished run.

Note: this is for the first version. This will be expanded later with
other requests and responses, as needed.

For native CI, the adapter actually is the CI engine and performs the
CI run itself. For external CI, the adapter process does whatever it
needs to do to get the external CI engine instance to perform the CI
run. If the CI engine calls back via web hook to notify of the run
finishing, the adapter process needs to receive the call and process
it.

External CI engines allow complex pipelines to be written and support 
a variety of workflows. Different jobs or tasks can be triggered
based on different events (e.g. `push`, `patch created`, `patch 
updated`, etc.), to satisfy different workflow needs. Some examples 
of real-world use-cases:

- trigger "fast" tests on every push to any branch
- trigger "relatively fast" tests only when a Patch is created / 
updated
- trigger "full test suite" on every push to the default branch (e.g. 
`main`)

In order to allow developers using Radicle the same flexibility that
they are used to on other forges, we want the broker to pass on 
whatever information it already has from the node events to the 
adapters, so they can pass it on to external CI systems, as appropriate. 

# Request and response messages

Note: the JSON objects below are formatted on multiple lines to make
them easier to read. The actual wire format is one line per message.


## Push Event Request

An example request that the broker sends looks like this:

~~~{.json .numberLines}
{
    "request": "trigger",
    "event_type": "push",
    "pusher": {
        "id": "did:key:z6MkltRpzcq2ybm13yQpyre58JUeMvZY6toxoZVpLZ8YabRa",
        "alias": "node_alias"
    },
    "before": "<BEFORE_COMMIT>",
    "after": "<AFTER_COMMIT>",
    "branch": "<BRANCH_NAME>"
    "commits": [
        "<SOME_OTHER_COMMIT_BEING_PUSHED>",
        "<AFTER_COMMIT>"
    ],
    "repository": {
        "id": "<RID>",
        "name": "heartwood",
        "description": "Radicle is a sovereign peer-to-peer network for 
        code collaboration, built on top of Git.",
        "private": false,
        "default_branch": "main",
        "delegates": [
          "did:key:z6MkltRpzcq2ybm13yQpyre58JUeMvZY6toxoZVpLZ8YabRa",
          "did:key:z6MkltRpzcq2ybm13yQpyre58JUeMvZY6toxoZVpLZ8YabRb"
        ]
    }
}
~~~

where:

  - `<RID>` is the repository ID, in its `rad:` URN format,
  - `<BRANCH_NAME>` is the branch name where the push occurred,
  - `<AFTER_COMMIT>` is the commit id of the last commit being pushed,
  - `<BEFORE_COMMIT>` is the commit id of the **parent** of the first 

commit being pushed (i.e. ` <SOME_OTHER_COMMIT_BEING_PUSHED>`),
(the SHA checksum). 

The `request` fields allows us to extend this in the future.

## Patch Event Request

An example request that the broker sends looks like this:

~~~{.json .numberLines}
{
    "request": "trigger",
    "event_type": "patch",
    "action": "created|updated",
    "patch": {
        "id": "<PATCH_ID>",
        "author": {
            "id": "did:key:z6MkltRpzcq2ybm13yQpyre58JUeMvZY6toxoZVpLZ8YabRa",
            "alias": "node_alias"
        },
        "title": "Add description in README",
        "state": {
            "status": "Open",
            "conflicts": [
                {
                    "revision_id": "string",
                    "oid": "string"
                }
            ]
        },
        "before": "<BEFORE_COMMIT>",
        "after": "<AFTER_COMMIT>",
        "commits": [
            "<SOME_OTHER_COMMIT_BEING_PUSHED>",
            "<AFTER_COMMIT>"
        ],
        "target": "delegates",
        "labels": [
            "small",
            "goodFirstIssue",
            "enhancement",
            "bug"
        ],
        "assignees": [
            "did:key:z6MkltRpzcq2ybm13yQpyre58JUeMvZY6toxoZVpLZ8YabRa"
        ],
        "revisions": [
            {
                "id": "41aafe22200464bf905b143d4233f7f1fa4a9123",
                "author": {
                    "id": "did:key:z6MkltRpzcq2ybm13yQpyre58JUeMvZY6toxoZVpLZ8YabRa",
                    "alias": "my_alias"
                },
                "description": "The revision description",
                "base": "193ed2f675ac6b0d1ab79ed65057c8a56a4fab23",
                "oid": "f0f5d38ffa8d54a7cc737fc4e75ab1e2e178eaa1",
                "timestamp": 1699437445
            }
        ]
    },
    "repository": {
        "id": "<RID>",
        "name": "heartwood",
        "description": "Radicle is a sovereign peer-to-peer network for 
        code collaboration, built on top of Git.",
        "private": false,
        "default_branch": "main",
        "delegates": [
          "did:key:z6MkltRpzcq2ybm13yQpyre58JUeMvZY6toxoZVpLZ8YabRa",
          "did:key:z6MkltRpzcq2ybm13yQpyre58JUeMvZY6toxoZVpLZ8YabRb"
        ]
    }
}
~~~

where:

  - `<RID>` is the reposiatory ID, in its `rad:` URN format,
  - `<AFTER_COMMIT>` is the commit id of the last commit being pushed,
  - `<BEFORE_COMMIT>` is the commit id of the **parent** of the first 

commit being pushed (i.e. ` <SOME_OTHER_COMMIT_BEING_PUSHED>`),
(the SHA checksum). 

The `request` fields allows us to extend this in the future.

## Responses

The first response from the adapter looks like this:

~~~{.json .numberLines}
{
    "response": "triggered",
    "run_id": "<RUNID>"
}
~~~

where `<RUNID>` is the id of the run that has been triggered.

The second response from the adapter looks like this:

~~~{.json .numberLines}
{
    "response": "finished",
    "result": "<STATUS>"
}
~~~

where `<STATUS>` is either the string `success` or `failure`. Note
that the run id is not repeated as the context makes this clear.
