use radicle::git::RefString;
use radicle::Profile;
use radicle_ci_broker::{
    event::BrokerEvent,
    msg::{Oid, RepoId, RequestBuilder, Response, RunId, RunResult},
};

fn main() {
    let rid = RepoId::from_urn("rad:zwTxygwuz5LDGBq255RA2CbNGrz8").expect("create rid");
    let commit =
        Oid::try_from("b4fb1e347be7db19f0859717062f94116b5bec9f").expect("create commit id");
    let name = RefString::try_from("refs/namespaces/z6MkgEMYod7Hxfy9qCvDv5hYHkZ4ciWmLFgfvm3Wn1b2w2FV/refs/heads/patches/8d8232ddcb217fa1402eec4d955e227ef3bb5881").expect("create name");
    let be = BrokerEvent::RefChanged {
        rid,
        name,
        oid: commit,
        old: None,
    };
    let profile = Profile::load().expect("create profile");
    let trigger = RequestBuilder::default()
        .profile(&profile)
        .broker_event(&be)
        .build_trigger()
        .expect("create trigger");
    println!("Trigger request:\n{}\n", trigger);

    let triggered = Response::triggered(RunId::from("any-string-works-as-run-id"));
    println!(
        "Triggered response:\n{}\n",
        serde_json::to_string(&triggered).expect("serialize message")
    );

    let finished = Response::finished(RunResult::Success);
    println!(
        "Successful response:\n{}\n",
        serde_json::to_string(&finished).expect("serialize message")
    );

    let finished = Response::finished(RunResult::Failure);
    println!(
        "Failure response:\n{}\n",
        serde_json::to_string(&finished).expect("serialize message")
    );

    let finished = Response::finished(RunResult::Error("error message\nsecond line".into()));
    println!(
        "Error response:\n{}\n",
        serde_json::to_string(&finished).expect("serialize message")
    );
}
