use std::{path::Path, str::FromStr};

use radicle::git::Oid;
use radicle::prelude::RepoId;

use radicle_ci_broker::{
    msg::{RunId, RunResult},
    pages::{PageBuilder, PageError},
    run::{Run, RunState, Whence},
};

const DIR: &str = "html";

fn main() -> Result<(), PageError> {
    let mut page = PageBuilder::default()
        .node_alias("radicle.liw.fi")
        .build()?;

    let rid1 = RepoId::from_urn("rad:z3gqcJUoA1n9HaHKufZs5FCSGazv5").unwrap();
    let alias1 = "heartwood";
    let mut run1 = Run::new(
        rid1,
        alias1,
        Whence::branch(
            "master",
            Oid::from_str("a48081f2717f069d456ec09f31d9e639b232dbed").unwrap(),
        ),
        "2024-02-27T18:29:25+02:00".into(),
    );
    run1.set_adapter_run_id(RunId::default());
    run1.set_state(RunState::Running);
    run1.set_result(RunResult::Success);
    page.push_run(run1.clone());

    let mut run2 = run1.clone();
    run2.set_state(RunState::Finished);
    page.push_run(run2);

    let mut run3 = Run::new(
        rid1,
        alias1,
        Whence::patch(
            Oid::from_str("60abd513e0fb858c0dfe95ad6c4aaeace9c25d60").unwrap(),
            Oid::from_str("091f7b7e986d05381718e2aeed2497c55dd0179a").unwrap(),
        ),
        "2024-02-27T18:29:09+02:00".into(),
    );
    run3.set_adapter_run_id(RunId::default());
    run3.set_state(RunState::Finished);
    run3.set_result(RunResult::Failure);
    page.push_run(run3);

    let rid2 = RepoId::from_urn("rad:zwTxygwuz5LDGBq255RA2CbNGrz8").unwrap();
    let alias2 = "radicle-ci-broker";
    let mut run4 = Run::new(
        rid2,
        alias2,
        Whence::branch(
            "master",
            Oid::from_str("79469d57841632ec4c0041f564e0b2b024abe7ec").unwrap(),
        ),
        "2024-02-27T18:29:25+02:00".into(),
    );
    run4.set_adapter_run_id(RunId::default());
    run4.set_state(RunState::Finished);
    run4.set_result(RunResult::Success);
    page.push_run(run4);

    page.write(Path::new(DIR)).unwrap();

    Ok(())
}
