use std::{error::Error, path::PathBuf};

use radicle_ci_broker::{db::Db, error::BrokerError};

fn main() {
    if let Err(e) = fallible_main() {
        eprintln!("ERROR: {}", e);
        let mut e = e.source();
        while let Some(source) = e {
            eprintln!("caused by: {}", source);
            e = source.source();
        }
    }
}

fn fallible_main() -> Result<(), BrokerError> {
    let mut args = std::env::args().skip(1);
    let filename: PathBuf = if let Some(filename) = args.next() {
        PathBuf::from(filename)
    } else {
        return Err(BrokerError::Usage);
    };

    let mut db = Db::new(&filename)?;
    for run in db.all_runs()? {
        println!("{run:#?}");
    }

    Ok(())
}
