use std::str::FromStr;

use radicle::git::{Oid, RefString};
use radicle::{
    node::Event,
    prelude::{NodeId, RepoId},
    storage::RefUpdate,
};

fn main() {
    let event = Event::RefsFetched {
        remote: NodeId::from_str("z6MkgEMYod7Hxfy9qCvDv5hYHkZ4ciWmLFgfvm3Wn1b2w2FV").unwrap(),
        rid: RepoId::from_urn("rad:zwTxygwuz5LDGBq255RA2CbNGrz8").unwrap(),
        updated: vec![RefUpdate::Skipped {
            name: RefString::try_from("shutdown").expect("create name"),
            oid: Oid::try_from("0").unwrap(),
        }],
    };
    println!("{}", serde_json::to_string(&event).unwrap());

    println!();

    let event = Event::RefsFetched {
        remote: NodeId::from_str("z6MkgEMYod7Hxfy9qCvDv5hYHkZ4ciWmLFgfvm3Wn1b2w2FV").unwrap(),
        rid: RepoId::from_urn("rad:zwTxygwuz5LDGBq255RA2CbNGrz8").unwrap(),
        updated: vec![RefUpdate::Updated {
            name: RefString::try_from("shutdown").expect("create name"),
            old: Oid::try_from("0").unwrap(),
            new: Oid::try_from("0").unwrap(),
        }],
    };
    println!("{}", serde_json::to_string(&event).unwrap());
}
