use std::{path::Path, str::FromStr};

use radicle::git::Oid;
use radicle::identity::Did;
use radicle::prelude::RepoId;

use radicle_ci_broker::{
    msg::{Author, Revision, RunId, RunResult},
    pages::{PageBuilder, PageError},
    run::{Run, RunState, Whence},
};

const DOMAIN: &str = "radicle.liw.fi";
const RID_1: &str = "rad:z3gqcJUoA1n9HaHKufZs5FCSGazv5";
const COMMIT_1: &str = "a48081f2717f069d456ec09f31d9e639b232dbed";
const USERID_1: &str = "J. Random Hacker <jrh@example.com>";
const AUTHOR_DID_3: &str = "did:key:z6MkgEMYod7Hxfy9qCvDv5hYHkZ4ciWmLFgfvm3Wn1b2w2FV";

const DIR: &str = "html";

fn main() -> Result<(), PageError> {
    let mut page = PageBuilder::default().node_alias(DOMAIN).build()?;

    let rid1 = rid(RID_1);
    let mut run1 = Run::new(
        rid1,
        "heartwood",
        Whence::branch("master", oid(COMMIT_1), Some(USERID_1)),
        "2024-02-27T18:29:25+02:00".into(),
    );
    run1.set_adapter_run_id(RunId::default());
    run1.set_state(RunState::Running);
    run1.set_result(RunResult::Success);
    page.push_run(run1.clone());

    let mut run2 = run1.clone();
    run2.set_state(RunState::Finished);
    page.push_run(run2);

    let mut run3 = Run::new(
        rid1,
        "heartwood",
        Whence::patch(
            oid(COMMIT_1),
            oid(COMMIT_1),
            Revision {
                id: oid(COMMIT_1),
                author: author(AUTHOR_DID_3),
                description: "Dummy patch description".into(),
                base: oid(COMMIT_1),
                oid: oid(COMMIT_1),
                timestamp: 0,
            },
            Some("Helpful Person <helpful@example.com>"),
        ),
        "2024-02-27T18:29:09+02:00".into(),
    );
    run3.set_adapter_run_id(RunId::default());
    run3.set_state(RunState::Finished);
    run3.set_result(RunResult::Failure);
    page.push_run(run3);

    let rid2 = RepoId::from_urn("rad:zwTxygwuz5LDGBq255RA2CbNGrz8").unwrap();
    let alias2 = "radicle-ci-broker";
    let mut run4 = Run::new(
        rid2,
        alias2,
        Whence::branch(
            "master",
            oid(COMMIT_1),
            Some("J. Random Hacker <random@example.com>"),
        ),
        "2024-02-27T18:29:25+02:00".into(),
    );
    run4.set_adapter_run_id(RunId::default());
    run4.set_state(RunState::Finished);
    run4.set_result(RunResult::Success);
    page.push_run(run4);

    page.write(Path::new(DIR)).unwrap();

    Ok(())
}

fn rid(urn: &str) -> RepoId {
    RepoId::from_urn(urn).unwrap()
}

fn oid(commit_id: &str) -> Oid {
    Oid::from_str(commit_id).unwrap()
}

fn did(did: &str) -> Did {
    Did::from_str(did).unwrap()
}

fn author(id: &str) -> Author {
    Author {
        id: did(id),
        alias: None,
    }
}
