# Release notes for `radicle-ci-broker`

This file summarizes the user-visible changes to `radicle-ci-broker`
between releases.


## Version 0.3.0, released 2024-07-xx

This is the third release. It breaks all existing installations.

### Bug fixes

* The CI broker now parses Git ref names for node identifiers more
  correctly.

* When the node sends an event about a branch having changed, the CI
  broker now allows the branch name to have slashes.

### New or changed features

* The `ci-broker` program has been replaced with the `cib` program,
  which is better in a few ways. Most importantly, it persists the
  node events that need to be processed, in a queue, so that they are
  not lost when the CI broker is re-started. The persistent storage is
  in the form of an SQLite database file: `ci-broker` used it already,
  but `cib` puts more information in it. There is also a list of all
  CI runs `cib` has performed.

* The `cibtool` program has been added to allow the node operator to
  manage `cib`, via the SQLite database file. `cibtool` lets the
  operator to view and manipulate the node event queue, and the list
  of CI runs, and to generate HTML report pages from information in
  the database. (`cib` generates the same report pages when running:
  `cibtool` functionality is there just in case.)

* CI broker logging continues to be inconsistent and helpful mainly to
  those developing the CI broker itself. Some logging has been
  removed, to avoid so called logspam.

* The code has been refactored a lot, for simplicity. This should be
  invisible to others, especially the adapter implementations, but
  just in case, be aware something externally visible may have changed
  inadvertently.

* The `BrokerEvent::is_allowed` method is no longer exposed in the CI
  broker public API. If you need it, let us know.

* The CI broker now logs the executable filename of the adapter it
  runs.

* The acceptance criteria for the CI broker are now documented in more
  detail in the subplot (see `ci-broker.md` and the
  [Subplot](https://subplot.tech/) software). The subplot document is
  available as
  [HTML](https://pages.radicle.liw.fi/ci-broker/ci-broker.html).

* Various undocumented helper programs have been dropped from the CI
  broker. Their functionality, if needed, can be added to `cibtool` in
  the future.


## Version 0.2.0, released 2024-06-06

This is the second release.

### Bug fixes

* The CI broker now picks the newest commit in a patch or branch,
  rather than the oldest. This means changes to a patch or branch get
  processed by CI, rather than only the first version. (Lars
  Wirzenius)

* Error messages are a little clearer now. An unclear error message is
  a bug. (Lars Wirzenius)

* Problems with the adapter sub-process failing are handled better
  now. (Lars Wirzenius)

* If the CI broker loses its connection to the Radicle node, the
  broker now terminates. Previously, it would keep trying to receive a
  message from the broken connection, which it would never receive,
  since the connection was broken in a way that it would not be mended
  even if the node is restarted. Computers are very patient, and never
  give up hope, so the CI broker was willing to wait until the heat
  death of the universe, or a power outage, whichever came first.

  Now, something like `systemd` can be used to restart the CI broker
  if this happens, and the system will recover. (Lars Wirzenius)


### New or changed features

* The CI broker depend on the version of the `radicle` crate that
  corresponds to the Radicle (heartwood) version 1.0.0 release
  candidate 10. This makes it possible to use the CI broker with the
  current version of Radicle. (Lars Wirzenius)

* The adapter protocol now allows an adapter to give the CI broker a
  URL related to the CI run. This can be used to link to a build log,
  for example. (Lars Wirzenius)

* The node event filter now has an `AnyPushRef` condition. (Michalis
  Zampetakis)

* The CI broker architecture documentation is now published to
  <https://pages.radicle.liw.fi/ci-broker/architecture.html> by CI
  whenever the CI broker is changed. (Lars Wirzenius)

* The logging for event handling a lot more verbose. This is useful
  for debugging problems, but is otherwise so noisy logs become nearly
  useless. (Lars Wirzenius)

* The documentation for the broker/adapter protocol should be up to
  date. (Michalis Zampetakis)

* The CI broker configuration now has the `sensitive_envs` field to
  allow specifying environment variables that should not be logged.
  (Lars Wirzenius)

* The CI broker can now be shut down cleanly. This is mostly useful
  for testing, though, at least for now, but opens up the possibility
  of shutting down only after any in-progress CI runs having finished
  first. (Lars Wirzenius)


## Version 0.1.0, released 2024-04-03

This was the first release. No notes.
