# Release process for the Radicle CI broker

Lars follows this process to make a release of the CI broker.

1. Make sure all the changes needed for the release have been made.
   - check open issues for anything urgent
   - check open patches for anything that should be included
   - check Zulip discussions for anything not captured in issues
1. Make sure the code in `main` can be deployed to `ci0` and CI runs
   successfully for all repositories.
   - `cibtool --db ci-broker.db trigger --all`
1. Start a branch for the release.
   - `git switch -c release`
1. Run `make`, ensure it's successful. This builds the code and runs
   the test suite.
1. Update version number in `Cargo.toml`, run `make semver` to verify
   the new version number follows semantic versioning.
1. Run `cargo update` to make sure `Cargo.lock` has the new crate version
   number.
1. Update new version in `debian/changelog` as well.
   - `dch -v a.b.c-1 New version.`
   - `dch -r ''`
1. Update `NEWS.md` basedon what's changed since the previous release.
   - `git log -p vA.B.C..`
1. Run `rad ci` to make sure CI runs successfully.
1. Commit changes.
   - `git commit -am "chore: prepare radicle-ci-broker release A.B.C."`
1. Check if publishing would work.
   - `cargo publish --dry-run`
1. Check `deb` building works. Throw away results.
   - `debian/build-deb`
   - `rm ../*_*`
1. Push patch, wait for CI to succeed.
   - `git push rad HEAD:refs/patches`
1. Merge patch, push merge.
   - `git switch main`
   - `git merge release`
   - `git push rad HEAD`
1. Create release tag.
   - `git tag -sam "radicle-ci-broker release version A.B.C"` vA.B.C
1. Publish crate.
   - `cargo publish`                                                                                                                                    
1. Build `deb`, import into the Radicle APT repository.
   - `debian/build-deb`                                                                                
1. Announce on Zulip in the `#annonce` channel in the topic for Radicle CI
   releases. Include `NEWS.md` snipppet for release, changing the top heading
   to mention "Radicle CI broker".
1. Upgrade my CI nodes to new releasse.
1. Update my other Radicle CI components if needed.
1. Add commit of new release to upgrade tests in `ci-broker.md`
