# Release notes for `radicle-ci-broker`

This file summarizes the user-visible changes to `radicle-ci-broker`
between releases.

## Version 0.24.0, released 2025-12-09

* The way `cib` looks up job COBs for specific commits has been optimized to
  use a cache. This speeds things up a lot in some circumstances: in one benchmark,
  creating 100 new runs for a commit went down from 600 seconds to 40.

* The log messages for a CI run, at the INFO level, are now easier to follow
  without being familiar with the code base. Especially the decision on
  whether an event filter should trigger CI to run is logged as one message
  and contains the whole decision tree as JSON.

* When it loads the configuration file, `cib` now checks that a default
  adapter is set, if the `filters` field is used. Previously a missing default
  adapter was only noticed later when starting a CI run. The new behavior
  exposes problems much earlier.


## Version 0.23.0, released 2025-11-25

* There is now a "terminate this CI run" event. It will make `cib` terminate a
  currently executing CI run. The event can be added to the event queue with
  `cibtool --db ci.db event terminate c12c6749-b708-4a2e-8ec1-c10f1e9817e4`, where
  the last argument is the broker run ID (not the adapter run ID).

* If the event queue has a "shut down" event, it it picked first. This avoids
  having to wait for the queue to be processed until the shut down event is
  next. The shut down event will prevent any new CI runs from being started.

* There is now a document on how to implement an
  adapter (`doc/adapter-impl.md`), rendered online at
  <https://radicle-ci.liw.fi/radicle-ci-broker/adapter-impl.html>.

* A small bug fix to the log messages for filtering tag events: the now say
  they are for tag events instead of branch events. The perils of having copy
  pasta for lunch. Found by Yorgos Saslis.

## Version 0.22.0, released 2025-11-12

* New event filter `AnyDelegate` is true if the change originates
  at any delegate node.

* There is an overview document of Radicle CI in `doc/overview.md`.

* A new configuration option `description` has been added to the
  `cib` configuration file. Its value is a snippet of HTML inserted
  at the top of the front page of the HTML report produced by the
  CI broker.

* The `cibtool trigger` command now has a `--message` option to get
  a trigger message instead of a trigger event. The message is what
  is given to the adapter as input via its stdin. The new option is
  useful for creating tests data for testing adapters.


## Version 0.21.0, released 2025-09-24

This entry was modified after the release, because the release process
is excessively manual and prone to mistakes.

* The event filters `TagCreated`, `TagUpdated`, and `TagDeleted` were
  added. They were supposed to have been added previously, and it was
  a bug they weren't.

* The minimum supported Rust version (`rust-version` in in `Cargo.toml`)
  is now 1.85. This is unrelated to the event filter change and fixes a
  bug in the previous release.


## Version 0.20.1, released 2025-09-19

* This release has no user-visible changed, but depends on newer
  versions of its Radicle dependencies, the `radicle`, `radicle-job`,
  and `radicle-git-ext` crates.

## Version 0.20.0, released 2025-09-09

### Bug fixes

* The configuration setting `max_run_time` has been fixed and now
  works, even if the adapter process produces less than two lines to
  its stdout. Previously, `cib` would wait for the adapter to either
  close its stdout, or to output at least two lines. HTML report pages
  now mention if a CI run is terminated due to taking too long.

* The pattern in events that match on tags now match the entire name
  of the tag, not just any substring.

* If a job COB for a specific commit already exists, it is updated,
  instead of creating a new COB for each CI run.

### Other changes

* The `cibtool trigger` command now has the option `--all` to trigger
  CI to run on all repositories known to the local node.

* The `cibtool trigger` command can now trigger CI to run on a patch
  with the `--patch` option.

* The `cibtool log` command can now read `cib` stderr log output
  directly, as is. The `--journal` option is changed to `--format`,
  which takes one of `journald` or `cib` as a value. This is
  technically a breaking change for those who use the command in
  scripts.

* The `cibtool log` command now has a `--jsonl` option to format
  output as JSON Lines, which means one JSON object per line, and one
  line per JSON object.

* The `cibtool run add` command now has a `--job ID` option to record
  the ID of the job COB for a run.

* The HTML report pages now mention the job COB ID for a run, if it is
  known.

* The configuration file fields `adapters` and `filters` are now
  optional. Not having the fields will make the CI broker instance
  somewhat useless, but it can be handy for testing other aspects of
  the software.

* The configuration field `status_update_interval_seconds` is now
  deprecated. The field has never actually been implemented. Instead
  of a fixed interval, the HTML report pages and `status.json` are
  updated whenever anything changes in CI runs: a run is started or
  ends.

* Problems managing job COBs are logged, but otherwise ignored. It's
  unfortunate if a job COB update fails, but it's not worth failing
  the run for, or to start a re-run.

* Packaging as a Debian `deb` package has been tidied up. As part of
  that, the `cib` and `cibtool` command now have manual pages.


## Version 0.19.1, released 2025-07-28

The main motivation for this release is to make changes to the
`radicle_ci_broker::msg::helper::AdminLog` type available to other
crates.

* A couple of typos have been fixed in documentation and command line
  help text.

* Dependencies on `radicle` and `radicle-job` crates have been updated
  to current. This should not be user visible, except possibly due to
  bugs being fixed.


## Version 0.19.0, released 2025-07-15

* The CI broker now creates "job COBs" when it runs CI. These are
  Radicle collaborative objects that record results of automated
  processing of repositories. The CI broker uses them to record that
  CI has started running on a commit, and what the result is.
  
  This is not yet useful without special tooling, but is a necessary
  step to enable automatically notifying users on other nodes of what
  is happening. It will become useful once Radicle user interfaces
  (`rad patch list`, `radicle-desktop`, and more) learn to show the
  status of automated processing, based on the job COBs. The job COB
  implementation in the `radicle-job` crate was made by Fintan
  Halpenny.

* The `cib` configuration file now allows configuring adapters, to
  simplify overall configuration by reducing the number of files
  involved. In the `cib` configuration file, an adapter specification
  can now include configuration for the adapter, using the `config`
  and `config_env` fields. This means `cib` will write the value of
  the `configb` field to a temporary file and set the environment
  variable named in the `config_env` field to the path to the
  temporary file.

* RSS feeds are now more correct, thanks to a patch and bug report
  from Sean Borg. He changed the feed item GUID field to no longer be
  marked as a permalink. He pointed out why feed items are sorted in
  the wrong way.

* Some documentation fixes by Tshepang Mbambo and Richard Levitte..

* A link to the new Radicle CI container adapter by Richard Levitte,
  who also made the new adapter.


## Version 0.18.0, released 2025-06-04

* The `cib` program (the CI broker service process) now refuses to
  start if its configuration uses in the `triggers` field an adapter
  that hasn't been defined in the `adatpters` field. Such a
  configuration would not do what the node operator expects it to do.
  
* All lines read from the adapter child process standard output are
  now logged. This helps node operators troubleshoot problems.

* In the `radicle_ci_broker::msg::helper` module for implementing
  adapters in Rust, the exit code of every command run is now logged
  explicitly, not just when it's non-zero. This makes it easier for
  node operators to debug problems by removing one small source of
  uncertainty about the result of running a command. If the exit code
  isn't there, maybe the command never exited?

* The logging of thread management and life cycle for processing CI
  events and running adapters has been slightly improved. An error
  from a thread is logged.


## Version 0.17.1, released 2025-05-19

* This is a "brown paper bag" release. I'd not added a test that
  verifies that the new `concurrent_adapters` field can be used in the
  configuration file. It is a truism that [if it's not tested, it
  doesn't
  work](https://yakking.branchable.com/posts/truism-4-if-it-is-not-tested/),
  and thus it doesn't work. This has been fixed now.

## Version 0.17.0, released 2025-05-19

* The CI broker can now run adapters concurrently. The maximum number
  of concurrent adapters can be set in the configuration file
  (`concurrent_adapters`), and defaults to one. A limitation is that
  only one CI run is executed at the same time per repository.

* Fixes to the documentation from Tshepang Mbambo and Arnaud Bailly.

* Minor update to the architecture document to simplify things.

* The user guide now has a section on installing Radicle CI with
  Ambient on Debian.

## Version 0.16.0, released 2025-04-17

* The version number now contains the Git commit short id, to reduce
  ambiguity for versions built from between-releases states of the
  source code repository.

* The user guide has gained a "Getting started" section.

* The README no longer claims the CI broker unsuitable for production
  use.

* There are now events for annotated Git tags, and corresponding
  filters that match a regular expression on the tag name. The events
  and filters are documented in the user guide.

* The `cibtool run remove` command now only takes broker run IDs. This
  allows removing a run whose info has an encoding error.

## Version 0.15.1, released 2025-03-26

* This release has no user-visible changes. It makes a change to the
  "message helper" module that is meant for Radicle CI adapters to
  use. The purpose of this release is to allow those adapters to
  depend on this release to get the helper functionality.

## Version 0.15.0, released 2025-03-25

* Fix a fatal problem when the CI broker is run with the report
  directory not existing (`report_dir` setting in the configuration
  file). Now, if the directory doesn't exist, the reports are not
  generated, but `cib` won't misbehave. There will be a log message at
  the warning level: "HTML report directory does not exist". If the
  directory is created later, while `cib` is running, reports will be
  written there.

* Related to the above, there are some improvements to log messages
  related to this. The log messages for worker threads starting and
  ending are now at info level, except if threads end in failure, at
  error level.

## Version 0.14.0, released 2025-03-24

Bug fixes:

* The Ci broker had a programming error where it would consider it a
  fatal error if a CI event referred to a Git ref that was not a patch
  or a branch. This would cause the CI broker to terminate, resulting
  in no CI running, and the CI broker process having to be re-started.
  This has been changed so that such Git refs are merely ignored. An
  example of such a Git ref is an update to `sigrefs`, which is
  fundamental to how Radicle works.

* When an event is picked from the event queue, it is removed at once.
  This means if something goes wrong while processing the event
  (running CI based on the event), the CI broker won't re-try the
  event. This avoids a situation where something in the event causes
  processing to always end due to an error, resulting in the CI broker
  re-trying the same event over and over, forever. With the new
  behavior, the event is tried only once, and if it fails, it's up to
  humans to figure out what caused this and to make it not happen
  again.

* Many problems in how Git references are handled have been fixed.
  Radicle deals with at least three types of Git references: branch
  names (`main`), qualified refs (`refs/heads/main`) and name spaced
  refs (`refs/namespaces/$NID/refs/main`). The CI broker is now more
  careful about keeping the different kinds apart. This results in the
  `DefaultBranch` filter to work more reliably, when previously in
  some cases it would not, because the plain branch name was compared
  to a name spaced ref.

Other changes:

* Logging is now more systematic and consistent. For example, all log
  messages are now structured, rather than just free form text. All
  log messages now have a `kind` field. All CI broker worker threads
  now emit a log message when they start and end, and if they end due
  to an error, the error is included in the log message.

* The new `cibtool event filter --explain` explains why a filter
  allows or denies an event.

* The RSS feeds produced by the CI broker now only contain up to ten
  entries. Apparently some RSS feed readers only remember a limited
  number of entries, and if the feed grows too long, they start
  treating really old entries as new. This can be alarming to the
  anxious developer who gets notified of failures in CI, only to later
  realize that it happened six months ago.
  
  The number ten is currently fixed. If need be, it can be made
  configurable.

* The user guide now has a chapter on configuring the CI broker.

## Version 0.13.1, released 2025-03-05

* The `NoneOf`, `AnyOf`, and `AllOf` aliases for CI event filters
  `Not`, `Or`, and `And`, respectively, have been added to the user
  guide.

* The CI broker now puts some metadata about CI runs to RSS feed
  entries, and has a feed for CI runs that have been triggered, or are
  running, but haven't finished.

* `cibtool run remove` can now remove information about CI runs from
  the database.
  
* `cibtool trigger` can output the event to trigger a CI run to the
  standard output, or a named file, instead of adding it the event
  queue in the database. This can be helpful to see what the event
  looks like, to troubleshoot weird problems.

* The `radicle_ci_broker::msg::helper` module now has an admin log,
  and the `runcmd` and `get_sources` function log what they do to the
  admin log.


## Version 0.13.0, released 2025-02-18

Bug fixes:
  
* CI event filter (de)serialization had problems that are now fixed.
  A `Not` expression could not always be parsed correctly. See below
  for a related breaking change.

Breaking changes:

* The CI event filter operator `Not` now takes a list of event
  filters, and allows an event, if none of the events in the list
  allow. This is a breaking change, because previously the operand of
  `Not` was a filter. The new way:
  
~~~yaml
- !Not
  - !Allow
~~~

  Previously this would have been: `!Not Allow`. That syntax no longer
  works.

* The CI broker configuration file must now only have known fields. A
  file with unknown fields is now rejected, which means the CI broker
  won't start. The purpose of this change is to ensure mis-spellings
  in configuration file fields are caught. Previously, if the field
  `report_dir` as spelled as `reportdidr`, it would have been silently
  ignored. Now it is a loud error.

New features:

* New CI event filter `!DefaultBranch` that checks if the event refers
  to the default branch of a Radicle repository.

* New CI event filter `!HasFile` that checks if the repository
  contains a specific file, in the commit that the event refers to.

* New aliases `!AllOf`, `!AnyOf`, and `!NoneOf` for CI filters `!And`,
  `!Or`, and `!Not`. For each filter, both aliases work in the
  identical way. The purpose of the aliases is to be easier to
  understand.

* The CI broker crate `radicle-ci-broker` has new helper functions in
  the `msg::helper` module: `get_source` to check out sources from the
  local node, and `runcmd` to run a command and capture its output.

* The `env` field for an adapter specification is now optional.

* The `cibtool trigger` command now defaults the ref to `main` and the
  commit to `HEAD`, which simplifies use for a common case.


## Version 0.12.0, released 2025-01-29

Breaking changes:

* The `radicle_ci_broker::msg::helper` module error type has been
  renames to `MessageHelperError` from `NativeMessageError`. The old
  name was misleading and copy-pasted from the Radicle native CI
  adapter.

* The `radicle_ci_broker::db::Db::queued_events` method has been
  dropped. This also means the CI broker no longer checks that the old
  "broker events" queue is empty when starting. Previously `cib` would
  refuse to start if the old queue wasn't empty. (The new queue has
  "CI events", which are different from "broker events". This change
  only affects the old queue, which hasn't been used in several
  releases.)

New features:

* There is now a new way to specify when a CI run should trigger,
  using the new `triggers` field in the configuration file. The new
  approach allows many runs to be triggered from one change, and each
  run can have a different CI adapter. See the user guide chapter
  "Triggering CI" for details. The old `filter` and `default_adapter`
  approach is still supported, but will eventually go away.

* As part of the `triggers` change, because of old mistakes, filtering
  of event now happens when queued events are processed. Previously,
  the filter was applied before an event was queued. This will
  hopefully not cause problems due to the event queue exploding in
  size. If it does cause problems, we can fix that, although it'll
  require a database schema change. Let us know.

* The `cibtool trigger` option `--ref` (also known as `--name`) now
  defaults to `main` and `--commit` defaults to `HEAD`. This makes the
  command a little bit more convenient to use.

* The frequency of how often the event queue length is logged can now
  be configured. This reduces log spam when the CI broker is idle. The
  setting is called `queue_len_interval` and is set to one hour by
  default.

* The source code repository for the CI broker now includes packaging
  for the NixOS operating system.


## Version 0.11.1, released 2025-01-09

This is primarily a bug fix release.

* The CI adapter wasn't capturing all standard error output from the
  adapter, if the adapter wrote an invalid message to its standard
  output. This has now been fixed.

* The `radicle_ci_broker::msg::helper` module has been added. It has
  some helpful functions for building CI adapters in Rust.


## Version 0.11.0, released 2025-01-07

* The CI broker no longer crashes if it fails to create a trigger
  message from a CI event. Previously, if there was some problem, such
  as a repository getting deleted between the CI event being added to
  the event queue and it getting picked up for processing, the CI
  broker would crash. The idea was that if the trigger message can't
  be created, the event can't be processed in a useful manner, and so
  it's better to give up. What really happened is that systemd or
  another system would re-start the CI broker, which would pick up the
  same event, and again fail to create trigger message, resulting in
  another crash.

  Now the CI broker will log the failure, delete the problematic event
  from the event queue, and then continue with the next event. This
  makes the CI broker more robust.

* Some log messages have "extra data" in separate fields, instead of
  the free-form message field. The separate fields are typically text
  with values in the Rust debug format, so they're still not very
  easily consumed by other programs, but they're at least easier to
  see.

* Log messages related to a specific CI run now include the broker run
  ID as an extra field. This makes it easier to extract all the
  messages related to a specific CI run.

* Most log messages now have an extra `msg_id` field that contains the
  type of message, such as `AdapterConfig`, `BrokerRunStart`, or
  `CibEndSuccess`. The full list is in the `src/logger.rs` source
  file.

* The `cibtool log` subcommand can extract `cib` log messages from the
  systemd journal:

~~~
sudo journalctl -S today -u radicle-ci-broker -o json | cibtool log --log-level info
~~~

  The output of `cibtool log` is JSON, which is reasonably easy to
  post-process by another program, such as `jq` or a small Python
  script.


## Version 0.10.0, released 2024-12-05

Bug fix:

* The CI broker now depends on version 0.14.0 of the `radicle` crate,
  to fix Git object identifier serialization and deserialization. You
  may need to remove any queued, but unprocessed CI events, using the
  command `cibtool --db foo.db event remove --all`. If your `cib`
  keeps crashing due to an error related to `Oid`, you need to do
  this.

* The CI broker now correctly sets the origin for a change. Previously
  it set it to node from which the change fetched. In a distributed
  system this may be a different node than the origin.

* The branch name in trigger messages in HTML reports has been fixed.
  It used to say "push-event-has-no-branch-name".

Other changes:

* Many log messages are now at a lower the "debug" log level to make
  it easier to remove log spam.

* Most log messages now have a `kind` field to allow better
  identification of what kind of message it is, without having to rely
  on parsing the free-form message text.

* Many log messages now have details in extra fields in the log
  message, rather than embed them in the free-form message text.

* The `cib` command now has help text for its options and subcommands,
  shown with the `--help` option and `help` subcommand.

## Version 0.9.0, released 2024-11-21

This release is mostly about small improvements.

* The log messages from the module that runs the adapter have been
  demoted from `debug` level to `trace`, so that they're easier to
  filter away.
* The per-adapter configuration setting `sensitive_envs` is now
  optional.
* The CI broker now generates two RSS feeds: one for all CI runs, and
  one for failures. This is a stop gap measure until we in Radicle
  decide how to distribute this information in a more reliable way.
* The CI broker HTML report pages have become a little nicer:
  - The per-repository pages have a link to the front page.
  - The event queue on the front page shows the alias for each
    repository, in addition to the repository id.
  - The front page shows counts of CI runs per-repository, and for all
    repositories together. There's a count of total runs, failed runs,
    and count of recent failures.
* Some improvements for the CI broker architecture documentation,
  currently published at <https://pages.radicle.liw.fi/ci-broker/>.

## Version 0.8.0, released 2024-11-08

This release has a major new feature (`max_run_time`, see first entry
below), which is also a bug fix, and was tricky to implement. That
meant it took a while and that delayed this release by weeks. There's
a bunch of smaller changes too.

* The way the CI broker runs a CI adapter has been rewritten to allow
  the node operator to set a time limit on a CI run, and to fix a bug
  where the CI broker would get stuck if the adapter produced too much
  output.

  To set the maximum duration of a CI run, add the `max_run_time`
  field to the configuration file. The default is one hour.

  Example: `max_run_time: 10h`

  The <https://docs.rs/duration-str/latest/duration_str/> page
  describes the unit suffixes that are supported.

* The event filters can now use the `Node` predicate to require
  changes to originate in a specific node.

* The `cibtool event remove` sub-command has an option `--all` to
  remove all queued events. This may be useful in the future for
  breaking upgrades, or when the node operator is having a bad day.

* The `cib` program does not start unless it has a local node.

* There is a start of a user guide, which is published automatically
  at <https://pages.radicle.liw.fi/ci-broker/userguide.html> for now.
  The location is likely to change in the future.

* The front report page now says if the CI run succeeded or failed, if
  the run has finished. Previously it only said the run had finished.

* The report pages are now updated whenever the state of a CI run
  changes. This makes it easier to follow the run via a web browser.
  Previously the pages were generated on a schedule.


## Version 0.7.0, released 2024-10-14

This release breaks many existing instances. The event filter
configuration needs to be reviewed upon upgrade, and the event queue
in the database needs to be emptied before running the new version.

### Breaking changes

* Internally, the CI broker now converts change events from the
  Radicle node into "CI events". In previous versions of the CI broker
  it used "broker events". CI events are different from broker events,
  and aim to be more suitable for CI purposes. This also affects the
  event filter in the CI broker configuration. See the new [user
  guide](https://app.radicle.xyz/nodes/radicle.liw.fi/rad:zwTxygwuz5LDGBq255RA2CbNGrz8/tree/doc/userguide.md)
  for details on the CI events.
  
  Note that in some simple cases, the old broker events match a new CI
  event exactly, for filtering. As an example, a filter on a specific
  branch is the same.
  
  The CI event changes only affect the configuration file and the
  database. The CI adapters and the messages communicating with them
  are not affected. Existing adapters work as before.

### Bug fixes

* The CI broker no longer logs the sensitive environment variables in
  clear text. Fix by Michalis.

* The CI broker no longer appends a "shut down" event to the event
  queue when it loses connection to the local Radicle node. This was a
  remnant of an old development phase, used to tell other threads in
  the CI broker to terminate. There is now a better way to do that and
  the spurious event is not needed. In fact, the spurious event would
  be processed by the CI broker after it got re-started, meaning the
  new process would immediately terminate. Ars long, vita brevis.

* The log message of the CI broker process ending with an
  unrecoverable error is not logged at the error level instead of the
  info level.

### Other changes

* A start of a CI broker user guide (aimed at node operators) has been
  added to the source repository. It will be published by the CI
  broker's CI on <https://pages.radicle.liw.fi/ci-broker/>.

* The CI broker now enables logging in trace and debug levels in
  release builds.

* CI broker logging level can be set with new `--log-level` command
  line option. This functionality was dropped when structured logging
  was added. Note that the old way of controlling logging level with
  an environment variable is still absent. Please open an issue if you
  want it back.

* The CI broker now logs a lot more detail. Possibly too much detail.

* The `cibtool event add --base` options value is not rev-parsed. This
  means a value like `HEAD` or `HEAD^` will work. Previously it had to
  be a commit SHA.

## Version 0.6.3, released 2024-09-16

A very small release that I make mostly to keep up a weekly release
cadence.

* Fix bug where CI broker would crash (panic) when generating HTML
  report pages. The cause was that it was assuming that each CI run
  had a run ID assigned by the CI adapter, and that they were unique.
  This was a faulty assumption. Luckily, all this code making the
  assumption had been made superfluous by earlier changes, so it could
  just be removed. This resulted in further simplification of the
  report generation code, but those should not be visible to users.

* Add the `cibtool event record` subcommand, to listen on node events
  and optionally write them to a file. As this uses the same code as
  `cib` to subscribe to node events, it's a way for node operators to
  verify that the CI broker can actually receive events.

* Add the `cibtool event broker` subcommand that reads a previously
  recorded (or constructed) file with node events and produces the
  corresponding broker events from them. This can be useful to create
  test files for verifying that event filters work as intended, for
  node operators.

* Add the `cibtool event filter` subcommand that reads a set of event
  filter expressions from one file, and broker events from another
  file, and writes out the events allowed by the filter. This is meant
  to be useful for node operators to verify that their event filters
  work as meant.


## Version 0.6.2, released 2024-09-10

A very small release that I make mostly to keep up a weekly release
cadence.

* `README.md` now documents dependencies that aren't Rust crates
  needed to run the test suite.

* A small bug fix to the acceptance test suite. The dummy adapter used
  in the suite did not read its stdin, so the adapter would sometimes
  finish before the CI adapter wrote the trigger message to the
  adapter's stdin, which failed, causing the whole test to fail.


## Version 0.6.1, released 2024-09-02

* This updates the dependencies on other Radicle crates, to make it
  easier to `cargo install` the CI broker.

## Version 0.6.0, released 2024-09-02

### Breaking changes
  
* The CI broker test suite now verifies that it can be upgraded
  without making changes to the configuration file or the database.
  This should lessen how often accidental, unintended breaking
  changes, so this counts as a user-visible lack of change. Note that
  this testing doesn't prevent breaking changes from being made, but
  makes it more likely that they'll be documented as such.

### New or changed features

* The CI broker now logs, to its own log, the standard error output of
  the CI adapter it runs, as well as their exist code. This should
  make it easier to debug problems in adapters, especially for the
  developers of the adapters. The log messages look like:
  
~~~json
{"msg":"adapter exit code","level":"DEBG","ts":"2024-08-27T17:38:26.762222386Z","exit_code":1}
{"msg":"adapter stderr","level":"DEBG","ts":"2024-08-27T17:38:26.762289242Z","stderr":"woe be me\n"}
~~~

* The `cibtool event list` command now has a `--jdon` option to output
  the event queue using the JSON format, for easier post-processing by
  other software.

* The CI broker logs its git commit when it starts.

* The CI broker [`README.md`](README.md) lists the known CI adapter,
  and links to documentation about using them.


## Version 0.5.0, released 2024-08-26

### Breaking changes

* All CI broker (`cib`) logging is now to the standard error output as
  JSON Lines: each log message is on its own line as one JSON object.
  This is a breaking change as it changes what is logged and how, and
  this may matter to those consuming the log output.

  The `RADICLE_CI_LOG` environment variable no longer affects CI
  broker logging.

* The `cibtool run add` option `--alias` has been removed. It was
  mis-named (repositories have names, not aliases), and also
  unnecessary, as the program can look up the repository name itself.
  Related to this, the JSON output calls it `repo_name` instead of
  `repo_alias`. However, when reading run information stored in the
  database, the old name is still accepted.

### New or changed features

* The `cibtool run add` option `--repo` can now take a repository
  name, instead of its id, if there is exactly one repository with
  that name in the local node.

* The HTML report front page now lists the current queue of
  unprocessed events, except for events for private repositories. The
  JSON status page includes the length of the queue.


## Version 0.4.0, released 2024-08-19

This is the fourth release. In breaking with tradition, it does not
have significant breaking changes.

### Breaking changes

* The `cibtool run list` command now lists only the identifiers of CI
  runs, one per line, by default. An option `--json` was added to get
  all the information in a format that's easy to parse with a program.
  This is a breaking change if you parse the output of the command
  with another command.

* The `cibtool run add` command no longer has a `--finished` option.
  It is now enough to use `--successful` or `--failure`. The dropped
  option was always used with one of those two, and those two were
  always used with the dropped option, so the dropped one was
  pointless and provided no extra information. It was just extra work
  for the user.

### Bug fixes

* The CI broker handles errors without panicking now. Instead of a
  stack trace, an actual error message is shown. This may be more
  friendly to most people.

* The CI broker now depends on Radicle 0.12.0, to say more current
  with changes in Radicle.

* The `cibtool run add` command sets the state correctly if the run
  has finished. Previously it was set to "triggered".

* Several instances of "CI" being spelled as "Ci" have been fixed, in
  log messages and help texts.


### New or changed features

* The HTML report pages produced by the CI broker are now a little
  more readable.

* The various parts of the running CI broker now notify each other
  that there have been changes so that the other parts can do what
  they need to do at once, instead of checking on a fixed schedule.
  This means, for example, that the HTML report pages for a run are
  updated at once, instead of once a minute.

* The `cib` and `cibtool` commands now both have an option `--version`
  to show the version number of the program.

* The `cibtool trigger` command makes it easier to trigger a CI run.
  This duplicates the functionality of `cibtool event add`, but is a
  little simpler to remember, and a little safer to use. The trigger
  command makes sure the base commit is always set in the event it
  creates. (The command to add an event does not, in cases users
  really want that behavior.)

* Each CI run now has two identifiers: one invented by the CI broker
  itself, guaranteed to be unique, and one chosen by the adapter,
  meant to reflect the identifier used by an external CI system, and
  guaranteed to be unique. Everywhere the user refers to a CI run,
  either ID is accepted, as long as the adapter one is unambiguous.
  When a run ID is shown, both kinds are shown.

* During a CI run, when anything happens, the information about the
  run  is updated in the database at once, instead of at the end of
  the run. This means the change is not lost in case the CI broker is
  terminated before the run finishes.

* New commands `cibtool run show` and `cibtool run update` to show
  information about a run, and update it. The updating is probably
  mostly only relevant to those writing test suites for the CI broker.

* Started documenting the acceptance criteria for logging in the CI
  broker, and how to verify that the criteria are met. This will
  probably continue over the next few releases. As part of this, the
  stakeholders are documented. In this release the list of
  stakeholders is quite rudimentary and the CI broker developers would
  like to hear from you if you have any wants or needs about the CI
  broker, whether about logging or otherwise.

  Additionally, this takes the first small steps towards having
  structured logging.


## Version 0.3.0, released 2024-07-18

This is the third release. It breaks all existing installations.

### Bug fixes

* The CI broker now parses Git ref names for node identifiers more
  correctly.

* When the node sends an event about a branch having changed, the CI
  broker now allows the branch name to have slashes.

### New or changed features

* The `ci-broker` program has been replaced with the `cib` program,
  which is better in a few ways. Most importantly, it persists the
  node events that need to be processed, in a queue, so that they are
  not lost when the CI broker is re-started. The persistent storage is
  in the form of an SQLite database file: `ci-broker` used it already,
  but `cib` puts more information in it. There is also a list of all
  CI runs `cib` has performed.

* The `cibtool` program has been added to allow the node operator to
  manage `cib`, via the SQLite database file. `cibtool` lets the
  operator to view and manipulate the node event queue, and the list
  of CI runs, and to generate HTML report pages from information in
  the database. (`cib` generates the same report pages when running:
  `cibtool` functionality is there just in case.)

* CI broker logging continues to be inconsistent and helpful mainly to
  those developing the CI broker itself. Some logging has been
  removed, to avoid so called logspam.

* The code has been refactored a lot, for simplicity. This should be
  invisible to others, especially the adapter implementations, but
  just in case, be aware something externally visible may have changed
  inadvertently.

* The `BrokerEvent::is_allowed` method is no longer exposed in the CI
  broker public API. If you need it, let us know.

* The CI broker now logs the executable filename of the adapter it
  runs.

* The acceptance criteria for the CI broker are now documented in more
  detail in the subplot (see `ci-broker.md` and the
  [Subplot](https://subplot.tech/) software). The subplot document is
  available as
  [HTML](https://pages.radicle.liw.fi/ci-broker/ci-broker.html).

* Various undocumented helper programs have been dropped from the CI
  broker. Their functionality, if needed, can be added to `cibtool` in
  the future.


## Version 0.2.0, released 2024-06-06

This is the second release.

### Bug fixes

* The CI broker now picks the newest commit in a patch or branch,
  rather than the oldest. This means changes to a patch or branch get
  processed by CI, rather than only the first version. (Lars
  Wirzenius)

* Error messages are a little clearer now. An unclear error message is
  a bug. (Lars Wirzenius)

* Problems with the adapter sub-process failing are handled better
  now. (Lars Wirzenius)

* If the CI broker loses its connection to the Radicle node, the
  broker now terminates. Previously, it would keep trying to receive a
  message from the broken connection, which it would never receive,
  since the connection was broken in a way that it would not be mended
  even if the node is restarted. Computers are very patient, and never
  give up hope, so the CI broker was willing to wait until the heat
  death of the universe, or a power outage, whichever came first.

  Now, something like `systemd` can be used to restart the CI broker
  if this happens, and the system will recover. (Lars Wirzenius)


### New or changed features

* The CI broker depend on the version of the `radicle` crate that
  corresponds to the Radicle (heartwood) version 1.0.0 release
  candidate 10. This makes it possible to use the CI broker with the
  current version of Radicle. (Lars Wirzenius)

* The adapter protocol now allows an adapter to give the CI broker a
  URL related to the CI run. This can be used to link to a build log,
  for example. (Lars Wirzenius)

* The node event filter now has an `AnyPushRef` condition. (Michalis
  Zampetakis)

* The CI broker architecture documentation is now published to
  <https://pages.radicle.liw.fi/ci-broker/architecture.html> by CI
  whenever the CI broker is changed. (Lars Wirzenius)

* The logging for event handling a lot more verbose. This is useful
  for debugging problems, but is otherwise so noisy logs become nearly
  useless. (Lars Wirzenius)

* The documentation for the broker/adapter protocol should be up to
  date. (Michalis Zampetakis)

* The CI broker configuration now has the `sensitive_envs` field to
  allow specifying environment variables that should not be logged.
  (Lars Wirzenius)

* The CI broker can now be shut down cleanly. This is mostly useful
  for testing, though, at least for now, but opens up the possibility
  of shutting down only after any in-progress CI runs having finished
  first. (Lars Wirzenius)


## Version 0.1.0, released 2024-04-03

This was the first release. No notes.
