#!/bin/bash

set -euo pipefail

message() {
	echo "~~~json"
	cargo run -q --bin cibtool -- message "$@" | jq .
	echo "~~~"
}

while read -r line; do
	case "$line" in
	@PUSH)
		message --kind=push
		;;
	@PATCH)
		message --kind=patch
		;;
	@TRIGGERED)
		message --kind=triggered
		;;
	@TRIGGEREDURL)
		message --kind=triggered --info-url=https://ci.example.com/runid/log.html
		;;
	@SUCCESS)
		message --kind=success
		;;
	@FAILURE)
		message --kind=failure
		;;
	@*)
		echo "Unknown directive: $line" 1>&2
		a exit 1
		;;
	*)
		echo "$line"
		;;
	esac
done <messages.txt
