# radicle-ci-broker

Add integration to CI engines/systems/services to
[Radicle](https://radicle.xyz/), a distributed git hosting and
collaboration system.

## Documentation

The `doc` directory holds some documentation for the Radicle CI Broker:

* If you plan to _user_ `radicle-ci-broker`, checkout the [User guide](doc/userguide.md)
* If you plan to contribute or extend `radicle-ci-broker`, checkout the [architecture document](doc/architecture.md)

HTML pages can be generated from the documentation.  To build those,
run `make` in the `doc` directory:

~~~
RADICLE_CI_BROKER_WEBROOT=/tmp/ci make -C doc publish
~~~

The `RADICLE_CI_BROKER_WEBROOT` environment variable defines where the
generated HTML pages should end up.

You'll need some tools installed: [Pandoc](https://pandoc.org),
[graphviz](https://www.graphviz.org) (dot),
[PlantUML](https://plantuml.com),
[pikchr-cli](https://crates.io/crates/pikchr-cli). The latter is a
Rust crate, so you can install it with `cargo install pikchr-cli`. The
other dependencies can usually be installed through your system
package manager. Note there's a [flake.nix](flake.nix) that provides
all the needed tools, use it with the usual `nix develop` command.

## Binaries

The crate contains several binaries:

* `cib` --- the actual CI broker
  - this is the only one you need to care about, the rest are for
    debugging
* `cibtool`  --- management tool for node operators, for managing the
  CI broker
* `synthetic-events`  --- test tool for CI broker developers


## Packaging

There is simple, simplistic, rudimentary, personal-use-only packaging
for Debian in the `debian` directory, used by Lars to build packages
for his own use.


## Running from the source tree

To run `cib` or `cibtool` from the source tree:

~~~sh
cargo run --bin cib -- --config config.yaml process-events
cargo run --bin cibtool -- --db ci-broker.db event list
~~~

Note the `--` argument. It tells `cargo run` that all the arguments
that follow are to be passed to the program being run, and not used by
`cargo` itself.


## Running tests

To run the test suite for the CI broker:

~~~sh
cargo test
~~~

(The usual way, for a Rust program.)

In addition to the usual Unix command line tools, you need the
following programs installed for the test suite:

* `jq`
* `git`
* `sqlite3`
* `rad` (from Radicle)
* `git-remote-rad` (from Radicle)
* `subplot` (Instructions [here](https://subplot.tech/download/). Required for `doc` make target.)

## Configuration

The configuration file is named on the command line. It is a YAML
file. See [`ci-broker.md`](ci-broker.md) for examples. Those examples
are verified to work every time the test suite runs.

## Adapters

You need to use an "adapter" together with the CI broker to actually
run CI on projects. At least the following adapters for external CI
systems are known:

* [Radicle Ambient adapter](https://app.radicle.xyz/nodes/radicle.liw.fi/rad:z35CgFVYCKpqqDtJMzk8dyE6dViS6)
  - Run CI using Ambient CI, in an isolated VM, for safety and security.
* [Radicle native CI](https://app.radicle.xyz/nodes/seed.radicle.xyz/rad:z3qg5TKmN83afz2fj9z3fQjU8vaYE)
  - Run CI on the node directly, using `.radicle/native.yaml`
* [Concourse integration](https://app.radicle.xyz/nodes/seed.radicle.garden/rad:z2woyw9Get9Q21VJzdbVz33b47xDb)
  - Integrate with the Concourse CI system
* [GitHub actions](https://explorer.radicle.gr/nodes/seed.radicle.gr/rad:z4Uh671FzoooaHjLvmtW9BtGMF9qm/tree/Node-Operator/GitHub-Actions-Integration.md)
  - Integrate with GitHub actions
* [Outgoing web hooks](https://explorer.radicle.gr/nodes/seed.radicle.gr/rad:z4Uh671FzoooaHjLvmtW9BtGMF9qm/tree/Node-Operator/Webhooks-Integration.md)
  - Call a remote web hook when an event occurs in a repository hosted on the Radicle network
* [Kraken](https://kraken.ci/blog/integration-with-radicle/)
  - Integrate with the Kraken CI system
* [Zulip Integration](https://explorer.radicle.gr/nodes/seed.radicle.gr/rad:z4Uh671FzoooaHjLvmtW9BtGMF9qm/tree/Node-Operator/Zulip-Integration.md)
  - Integrate with Zulip chat for getting informed about new events on repos
* [Container CI](https://app.radicle.xyz/nodes/rad.levitte.org/rad:z2ZTDBgsGxMDyLjATZ4rcr63twmTJ)
  - Run CI on the node in `podman` containers, using `.radicle/native.yaml` (Radicle Native CI compatibility) or `.radicle/cci.yaml`

See also the
[radicle-ci-integrations-docs](https://explorer.radicle.gr/nodes/seed.radicle.gr/rad:z4Uh671FzoooaHjLvmtW9BtGMF9qm)
repository with guides for project maintainers and node operators
about using Radicle CI. They too list CI adapters.


## License

Radicle CI broker is distributed under the terms of both the MIT
license and the Apache License (Version 2.0).

See [LICENSE-APACHE](LICENSE-APACHE) and [LICENSE-MIT](LICENSE-MIT) for details.
