use std::sync::{Arc, Mutex};

use url::Url;

use radicle::{git::Oid, identity::RepoId};

use radicle_ci_broker::cob::*;

use super::*;

#[derive(Parser)]
pub struct CobCmd {
    /// ID of repository.
    repo_id: RepoId,

    /// Git object ID.
    oid: Oid,

    /// Create this many runs in job COB.
    n: usize,

    /// Announce changes?
    #[clap(long)]
    announce: bool,
}

impl Leaf for CobCmd {
    fn run(&self, _args: &Args) -> Result<(), CibToolError> {
        let url = Url::parse("https://liw.fi").unwrap();
        let run_id = RunId::default();
        let known = Arc::new(Mutex::new(
            KnownJobCobs::new().map_err(CibToolError::KnownJobCobs)?,
        ));
        for i in 0..self.n {
            println!("{i}");
            let mut known = known.lock().unwrap();
            known.create_run(self.repo_id, self.oid, run_id.clone(), &url, self.announce);
        }
        Ok(())
    }
}
