use std::{path::Path, time::SystemTime};

use radicle_ci_broker::msg::{Oid, RepoId};

use radicle_native_ci::{runlog::RunLog, runspec::RunSpec};

/// The main program.
fn main() {
    let mut run_log = RunLog::new(Path::new("testlog.html"));
    run_log.title("Some Title");
    run_log.rid(
        RepoId::from_urn("rad:z3qg5TKmN83afz2fj9z3fQjU8vaYE").expect("rid"),
        "colossal",
    );
    run_log.commit(Oid::try_from("b788f7ffd38572614457adb1656c0b4575b941dd").expect("commit"));
    run_log.branch("xyzzy");
    run_log.patch(
        Oid::try_from("e676fde7bfc7f8d433b50d73a236601d1f63cec3").unwrap(),
        "This be my patch",
    );
    run_log.runspec(RunSpec {
        shell: "echo hello, world".into(),
    });
    let started = SystemTime::now();
    let ended = SystemTime::now();
    run_log.runcmd(
        &["git", "pull"],
        Path::new("/tmp"),
        0,
        "This is stdout".as_bytes(),
        started,
        ended,
    );
    run_log.runcmd(
        &["cargo", "check", "--all-targets", "--workspace"],
        Path::new("/tmp"),
        0,
        "This is stdout".as_bytes(),
        started,
        ended,
    );

    run_log.write().expect("write html log");
}
