# radicle-native-ci

This is an adapter for the [Radicle CI broker], for performing CI runs
locally. This means it reads a JSON message from its stdin, and writes
two JSON messages to its stdout. Its configured via a configuration
file specified in the `RADICLE_NATIVE_CI` environment variable. There
is currently no logging.

The CI run is performed locally, without any isolation. This is not
safe and secure, but it's simple, and easy to get working. Do not use
this unless you trust the repository and its dependencies.

The repository must contain a file `./radicle/native.yaml` that
specifies how CI is run for the repository. For example:

```yaml
shell: |
  cargo test --locked --workspace
```

 [Radicle CI broker]: https://app.radicle.xyz/nodes/radicle.liw.fi/rad:zwTxygwuz5LDGBq255RA2CbNGrz8


## Architecture

See the [documentation](doc) directory for an architecture document.


## Configuration

The adapter requires the `RADICLE_NATIVE_CI` environment variable to
be set to the filename of a configuration file in YAML. For example:

~~~yaml
state: /srv/http
log: /home/_rad/native-ci.log
~~~

The fields are:

* `state` --- required, directory where per-run directories are stored
* `log` --- required, file where native CI should write a log
* `timeout` --- optional, maximum duration of the run, in seconds


## Packaging

There is simple, simplistic, rudimentary, personal-use-only packaging
for Debian in the `debian` directory, used by Lars to build packages
for his own use.


## Running tests

To run the test suite for the CI broker:

~~~sh
cargo test
~~~

(The usual way, for a Rust program.)

Also, there is `.radicle/native.yaml` for testing this with itself in
Radicle CI. You may want to run those manually.


## License

Radicle native CI is distributed under the terms of both the MIT
license and the Apache License (Version 2.0).

See [LICENSE-APACHE](LICENSE-APACHE) and [LICENSE-MIT](LICENSE-MIT) for details.
