# Release notes about `radicle-native-ci`

This file summarizes the user-visible changes to `radicle-native-ci`
between releases.

## Version 0.11.1, released 2025-07-28

* The run log HTML now tries to import `local.css` to allow local
  styling of the page. By Aleks Rutins.

* The `README.md` file now links to the architecture document. By Sean
  Borg.

* The dependencies on the `radicle` and `radicle-ci-broker` crates are
  now on current versions. This should be user-invisible, except for
  bugs fixed.

## Version 0.11.0, released 2025-06-05

* No functional changes, but updates dependencies to current versions
  of the `radicle` and `radicle-ci-broker` crates to avoid breakages.

## Version 0.10.0, released 2025-04-22

* This release has no user-visible changes, and only upgrades its
  dependency on the CI broker, to avoid falling behind and making a
  future upgrade harder.

## Version 0.9.0, released 2025-03-26

* This release has no user-visible changes, and only upgrades its
  dependencies to current versions.

## Version 0.8.0, released 2025-02-18

* The `rad-ci` binary has been dropped from this crate, as the new
  `rad-ci` crate provides a better version now.

## Version 0.7.0, released 2025-02-03

* The `README.md` file documents the exit codes used by the adapter,
  and that the adapter administrator log goes to the standard error
  output. Other documentation improvements as well.

## Version 0.6.0, released 2025-01-07

* The `rad-ci` program now parses its command line in a more usual
  Unix manner. It now has the `--dry-run` option, as well as `-h`
  and `--help` options.

* The CI adapter no longer has support for limiting the duration of a
  CI run. The Radicle CI broker has that functionality, so there's no
  need for the adapter to have it too.
  
  This is a breaking change. The adapter configuration file may no
  longer have the `timeout` field.

* The log for the CI run now includes the adapter-assigned run ID, and
  run start time and duration.


## Version 0.5.0, released 2024-12-05

* The admin log (written to file specified in the configuration file)
  now has time stamps for message. Suggested by Richard Levitte.

* The README documents `base_url`. Change by Richard Levitte.

## Version 0.4.0, released 2024-11-22

* The `rad-ci` binary is added. This is an **experimental** tool for
  running the commands CI runs without going via CI. See the README
  for details.


## Version 0.3.0, released 2024-11-14

This is the third release. The release notes were added later.

* The `--version` option was added to show the version number of the
  program.

* The `--show-config` option was added to show the configuration being
  used as JSON.

* The configuration file now has an optional `base_url` field to set
  the base URL for constructing the URL to the log file, so that the
  URL can be sent to the CI broker.

* In log files, the stdout and stderr of the commands that are run are
  combined into one stream. This makes logs easier to follow.

* Log files now have a more prominent and comprehensive table of
  contents.


## Version 0.2.0, released 2024-06-06

This is the second release.

* The main change is that this version depends on version 0.2.0 of the
  CI broker. This fixes the problem of building the oldest commit in a
  patch rather than the newest.

* The README is more useful now.


## Version 0.1.0, released 2024-04-03

This was the first release. No notes.
