# radicle-native-ci

This is an adapter for the [Radicle CI broker], for performing CI runs
locally. This means it reads a JSON message from its stdin, and writes
two JSON messages to its stdout. Its configured via a configuration
file specified in the `RADICLE_NATIVE_CI` environment variable.

The adapter writes an "admin log" to its standard error output, aimed
at the node operator who uses Radicle CI.

The CI run is performed locally, without any isolation. This is not
safe and secure, but it's simple, and easy to get working. Do not use
this unless you trust the repository and its dependencies.

The repository must contain a file `./radicle/native.yaml` that
specifies how CI is run for the repository. For example:

```yaml
shell: |
  cargo test --locked --workspace
```

[Radicle CI broker]: https://app.radicle.xyz/nodes/radicle.liw.fi/rad:zwTxygwuz5LDGBq255RA2CbNGrz8

This will read `.radicle/native.yaml` and run the shell commands
specified there.

## Architecture

See the [documentation](doc) directory for an architecture document.


## Configuration

The adapter requires the `RADICLE_NATIVE_CI` environment variable to
be set to the filename of a configuration file in YAML. For example:

~~~yaml
base_url: https://ci.example.org/state
state: /srv/http
log: /home/_rad/native-ci.log
~~~

The fields are:

* `base_url` --- base URL for build logs (mandatory for access from CI broker page)
* `state` --- required, directory where per-run directories are stored
* `log` --- required, file where native CI should write the run log

The run log is aimed at the developers of the contents of the
repository, instead of the node operator.


## Exit codes

The `radicle-native-ci` executable uses the following exit codes:

* 0 = success, everything went well.
* 1 = failure, the CI run finished, but failed
* 2 = error, the CI run could not be finished

An example of a failure is when the CI run builds software that has a
syntax error.

An example of an error is when the adapter configuration file is
missing.

## Packaging

There is simple, simplistic, rudimentary, personal-use-only packaging
for Debian in the `debian` directory, used by Lars to build packages
for his own use.


## Running tests

To run the test suite for the CI broker:

~~~sh
cargo test
~~~

(The usual way, for a Rust program.)

Also, there is `.radicle/native.yaml` for testing this with itself in
Radicle CI. You may want to run those manually:

~~~sh
yq -r .shell .radicle/native.yaml  | bash -e
~~~

(`yq` is a program like `jq`, but for YAML files. You can also
manually extract the `shell` field from `.radicle/native.yaml`.)

## License

Radicle native CI is distributed under the terms of both the MIT
license and the Apache License (Version 2.0).

See [LICENSE-APACHE](LICENSE-APACHE) and [LICENSE-MIT](LICENSE-MIT) for details.
