use clap::Parser;

use crate::{
    sop::{Sop, SopError},
    Config, LeafCommand,
};

#[derive(Debug, Parser)]
pub struct ExtractCert {}

impl LeafCommand for ExtractCert {
    type Error = KeyError;

    fn run(&self, config: &Config) -> Result<(), KeyError> {
        let sop = Sop::new(config.sop(), config.key_file());
        let cert = sop.extract_cert()?;
        let cert = String::from_utf8_lossy(cert.as_bytes());
        println!("{cert}");
        Ok(())
    }
}

#[derive(Debug, thiserror::Error)]
pub enum KeyError {
    #[error(transparent)]
    Sop(#[from] SopError),
}
