use clap::Parser;

use crate::{Config, LeafCommand};

#[derive(Debug, Parser)]
pub struct VersionCommand {}

impl LeafCommand for VersionCommand {
    type Error = VersionError;

    fn run(&self, _config: &Config) -> Result<(), VersionError> {
        println!("{} {}", env!("CARGO_PKG_NAME"), env!("CARGO_PKG_VERSION"));
        Ok(())
    }
}

#[derive(Debug, thiserror::Error)]
pub enum VersionError {}
