use std::path::{Path, PathBuf};

use crate::DEFAULT_KEY_FILENAME;

#[derive(Debug)]
pub struct Config {
    store: PathBuf,
    key_file: PathBuf,
    sop: PathBuf,
}

impl Config {
    pub fn new(store: &Path, sop: &Path) -> Self {
        Self {
            store: store.into(),
            key_file: store.join(DEFAULT_KEY_FILENAME),
            sop: sop.into(),
        }
    }

    pub fn store(&self) -> &Path {
        &self.store
    }

    pub fn key_file(&self) -> &Path {
        &self.key_file
    }

    pub fn sop(&self) -> &Path {
        &self.sop
    }
}
